/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.BaseMetastoreOperations;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import org.apache.iceberg.view.ViewOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseViewOperations
extends BaseMetastoreOperations
implements ViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BaseViewOperations.class);
    private static final String METADATA_FOLDER_NAME = "metadata";
    private ViewMetadata currentMetadata = null;
    private String currentMetadataLocation = null;
    private boolean shouldRefresh = true;
    private int version = -1;

    protected BaseViewOperations() {
    }

    protected void requestRefresh() {
        this.shouldRefresh = true;
    }

    protected void disableRefresh() {
        this.shouldRefresh = false;
    }

    protected abstract void doRefresh();

    protected abstract void doCommit(ViewMetadata var1, ViewMetadata var2);

    protected abstract String viewName();

    protected abstract FileIO io();

    protected String currentMetadataLocation() {
        return this.currentMetadataLocation;
    }

    protected int currentVersion() {
        return this.version;
    }

    @Override
    public ViewMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    @Override
    public ViewMetadata refresh() {
        boolean currentMetadataWasAvailable = this.currentMetadata != null;
        try {
            this.doRefresh();
        }
        catch (NoSuchViewException e) {
            if (currentMetadataWasAvailable) {
                LOG.warn("Could not find the view during refresh, setting current metadata to null", (Throwable)e);
                this.shouldRefresh = true;
            }
            this.currentMetadata = null;
            this.currentMetadataLocation = null;
            this.version = -1;
            throw e;
        }
        return this.current();
    }

    @Override
    public void commit(ViewMetadata base, ViewMetadata metadata) {
        if (base != this.current()) {
            if (base != null) {
                throw new CommitFailedException("Cannot commit: stale view metadata", new Object[0]);
            }
            throw new AlreadyExistsException("View already exists: %s", this.viewName());
        }
        if (base == metadata) {
            LOG.info("Nothing to commit.");
            return;
        }
        long start = System.currentTimeMillis();
        this.doCommit(base, metadata);
        this.requestRefresh();
        LOG.info("Successfully committed to view {} in {} ms", (Object)this.viewName(), (Object)(System.currentTimeMillis() - start));
    }

    private String writeNewMetadata(ViewMetadata metadata, int newVersion) {
        String newMetadataFilePath = this.newMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.io().newOutputFile(newMetadataFilePath);
        ViewMetadataParser.overwrite(metadata, newMetadataLocation);
        return newMetadataLocation.location();
    }

    protected String writeNewMetadataIfRequired(ViewMetadata metadata) {
        return null != metadata.metadataFileLocation() ? metadata.metadataFileLocation() : this.writeNewMetadata(metadata, this.version + 1);
    }

    private String newMetadataFilePath(ViewMetadata metadata, int newVersion) {
        String codecName = metadata.properties().getOrDefault("write.metadata.compression-codec", "gzip");
        String fileExtension = TableMetadataParser.getFileExtension(codecName);
        return this.metadataFileLocation(metadata, String.format(Locale.ROOT, "%05d-%s%s", newVersion, UUID.randomUUID(), fileExtension));
    }

    private String metadataFileLocation(ViewMetadata metadata, String filename) {
        return String.format("%s/%s/%s", LocationUtil.stripTrailingSlash(metadata.location()), METADATA_FOLDER_NAME, filename);
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        this.refreshFromMetadataLocation(newLocation, null, 20);
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        this.refreshFromMetadataLocation(newLocation, shouldRetry, numRetries, metadataLocation -> ViewMetadataParser.read(this.io().newInputFile((String)metadataLocation)));
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries, Function<String, ViewMetadata> metadataLoader) {
        if (!Objects.equal(this.currentMetadataLocation, newLocation)) {
            LOG.info("Refreshing view metadata from new version: {}", (Object)newLocation);
            AtomicReference newMetadata = new AtomicReference();
            Tasks.foreach(newLocation).retry(numRetries).exponentialBackoff(100L, 5000L, 600000L, 4.0).throwFailureWhenFinished().stopRetryOn(NotFoundException.class).shouldRetryTest(shouldRetry).run(metadataLocation -> newMetadata.set((ViewMetadata)metadataLoader.apply((String)metadataLocation)));
            this.currentMetadata = (ViewMetadata)newMetadata.get();
            this.currentMetadataLocation = newLocation;
            this.version = BaseViewOperations.parseVersion(newLocation);
        }
        this.shouldRefresh = false;
    }

    private static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        if (versionEnd < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse version from metadata location: {}", (Object)metadataLocation, (Object)e);
            return -1;
        }
    }
}

