/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.regions.Region;

public class AwsAuthenticationProvider
implements NessieAuthenticationProvider {
    public static final String AUTH_TYPE_VALUE = "AWS";

    public static HttpAuthentication create(Region region) {
        return AwsAuthenticationProvider.create(region, null);
    }

    public static HttpAuthentication create(Region region, String profile) {
        return new AwsAuthentication(region, profile);
    }

    @Override
    public String getAuthTypeValue() {
        return AUTH_TYPE_VALUE;
    }

    @Override
    public HttpAuthentication build(Function<String, String> parameters) {
        String regionName = parameters.apply("nessie.authentication.aws.region");
        if (regionName == null) {
            regionName = Region.US_WEST_2.toString();
        }
        Region region = AwsAuthenticationProvider.awsRegion(regionName);
        String profile = parameters.apply("nessie.authentication.aws.profile");
        return AwsAuthenticationProvider.create(region, profile);
    }

    private static Region awsRegion(String regionName) {
        return Region.regions().stream().filter(r -> r.toString().equalsIgnoreCase(regionName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown region '%s'.", regionName)));
    }

    private static class AwsAuthentication
    implements HttpAuthentication {
        private final Region region;
        private final AwsCredentialsProvider awsCredentialsProvider;
        private final ObjectMapper objectMapper;

        private AwsAuthentication(Region region, String profile) {
            this.region = region;
            DefaultCredentialsProvider.Builder provider = DefaultCredentialsProvider.builder();
            if (profile != null) {
                provider.profileName(profile);
            }
            this.awsCredentialsProvider = provider.build();
            this.objectMapper = new ObjectMapper().disable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        }

        @Override
        public void applyToHttpClient(HttpClient.Builder client) {
            client.addRequestFilter(this::applyToHttpRequest);
        }

        @Override
        public void applyToHttpRequest(RequestContext context) {
            SdkHttpFullRequest request = this.prepareRequest(context.getUri(), context.getMethod(), context.getBody());
            AwsCredentials identity = this.awsCredentialsProvider.resolveCredentials();
            String signingName = "execute-api";
            SdkHttpRequest modReq = AwsV4HttpSigner.create().sign(b -> {
                ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)b.request((SdkHttpRequest)request)).identity((Identity)identity)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.region.id())).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)signingName);
                request.contentStreamProvider().ifPresent(arg_0 -> ((SignRequest.Builder)b).payload(arg_0));
            }).request();
            for (Map.Entry entry : modReq.headers().entrySet()) {
                if (context.containsHeader((String)entry.getKey())) continue;
                ((List)entry.getValue()).forEach(a -> context.putHeader((String)entry.getKey(), (String)a));
            }
        }

        private SdkHttpFullRequest prepareRequest(URI uri, HttpClient.Method method, Optional<Object> entity) {
            try {
                SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().uri(uri).method(SdkHttpMethod.fromValue((String)method.name()));
                String query = uri.getQuery();
                if (query != null) {
                    Arrays.stream(query.split("&")).map(s2 -> s2.split("=")).forEach(s2 -> builder.putRawQueryParameter(s2[0], s2[1]));
                }
                if (entity.isPresent()) {
                    try {
                        byte[] bytes = this.objectMapper.writeValueAsBytes(entity.get());
                        builder.contentStreamProvider(() -> new ByteArrayInputStream(bytes));
                    }
                    catch (Throwable t2) {
                        throw new RuntimeException(t2);
                    }
                }
                return builder.build();
            }
            catch (Throwable t3) {
                throw new RuntimeException(t3);
            }
        }
    }
}

