/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.Optional;
import org.projectnessie.client.auth.oauth2.DeviceCodeRequest;
import org.projectnessie.client.auth.oauth2.DeviceCodeResponse;
import org.projectnessie.client.auth.oauth2.Flow;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;
import org.projectnessie.client.auth.oauth2.TokenResponseBase;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponse;

abstract class AbstractFlow
implements Flow {
    final OAuth2ClientConfig config;

    AbstractFlow(OAuth2ClientConfig config) {
        this.config = config;
    }

    <REQ extends TokenRequestBase, RESP extends TokenResponseBase> Tokens invokeTokenEndpoint(TokenRequestBase.Builder<REQ> request, Class<? extends RESP> responseClass) {
        request.extraParameters(this.config.getExtraRequestParameters());
        this.getScope().ifPresent(request::scope);
        this.maybeAddClientId(request);
        return ((TokenResponseBase)this.invokeEndpoint(this.getResolvedTokenEndpoint(), request.build(), responseClass)).asTokens(this.config.getClock());
    }

    DeviceCodeResponse invokeDeviceAuthEndpoint() {
        DeviceCodeRequest.Builder request = DeviceCodeRequest.builder();
        this.getScope().ifPresent(request::scope);
        this.maybeAddClientId(request);
        return this.invokeEndpoint(this.config.getResolvedDeviceAuthEndpoint(), request.build(), DeviceCodeResponse.class);
    }

    Optional<String> getScope() {
        return this.config.getScopes().stream().reduce((a, b) -> a + " " + b);
    }

    URI getResolvedTokenEndpoint() {
        return this.config.getResolvedTokenEndpoint();
    }

    String getClientId() {
        return this.config.getClientId();
    }

    boolean isPublicClient() {
        return this.config.isPublicClient();
    }

    Optional<HttpAuthentication> getBasicAuthentication() {
        return this.config.getBasicAuthentication();
    }

    private void maybeAddClientId(Object request) {
        if (this.isPublicClient() && request instanceof PublicClientRequest.Builder) {
            ((PublicClientRequest.Builder)request).clientId(this.getClientId());
        }
    }

    private <REQ, RESP> RESP invokeEndpoint(URI endpoint, REQ request, Class<? extends RESP> responseClass) {
        HttpRequest req = this.config.getHttpClient().newRequest(endpoint);
        this.getBasicAuthentication().ifPresent(req::authentication);
        HttpResponse response = req.postForm(request);
        return response.readEntity(responseClass);
    }
}

