/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v1;

import jakarta.validation.constraints.NotNull;
import org.projectnessie.api.v1.http.HttpContentApi;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;

class RestV1ContentClient
implements HttpContentApi {
    private final HttpClient client;

    RestV1ContentClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public Content getContent(@javax.validation.constraints.NotNull @NotNull ContentKey key, String ref, String hashOnRef) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").path(key.toPathString()).queryParam("ref", ref).queryParam("hashOnRef", hashOnRef).get().readEntity(Content.class);
    }

    @Override
    public GetMultipleContentsResponse getMultipleContents(@javax.validation.constraints.NotNull @NotNull String ref, String hashOnRef, @javax.validation.constraints.NotNull @NotNull GetMultipleContentsRequest request) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").queryParam("ref", ref).queryParam("hashOnRef", hashOnRef).post(request).readEntity(GetMultipleContentsResponse.class);
    }
}

