/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends BaseMetastoreCatalog
implements Closeable,
SupportsNamespaces {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private final String name;
    private final HiveClientPool clients;
    private final Configuration conf;
    private final StackTraceElement[] createStack;
    private boolean closed;

    public HiveCatalog(Configuration conf) {
        this.name = "hive";
        this.clients = new HiveClientPool(conf);
        this.conf = conf;
        this.createStack = Thread.currentThread().getStackTrace();
        this.closed = false;
    }

    public HiveCatalog(String name, String uri, int clientPoolSize, Configuration conf) {
        this.name = name;
        this.conf = new Configuration(conf);
        if (uri != null) {
            this.conf.set("hive.metastore.uris", uri);
        }
        this.clients = new HiveClientPool(clientPoolSize, this.conf);
        this.createStack = Thread.currentThread().getStackTrace();
        this.closed = false;
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Missing database in namespace: %s", (Object)namespace);
        String database = namespace.level(0);
        try {
            List tables = this.clients.run(client -> client.getAllTables(database));
            return tables.stream().map(t -> TableIdentifier.of((Namespace)namespace, (String)t)).collect(Collectors.toList());
        }
        catch (UnknownDBException e) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables under namespace " + namespace, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listTables", e);
        }
    }

    protected String name() {
        return this.name;
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        if (!this.isValidIdentifier(identifier)) {
            return false;
        }
        String database = identifier.namespace().level(0);
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        try {
            this.clients.run(client -> {
                client.dropTable(database, identifier.name(), false, false);
                return null;
            });
            if (purge && lastMetadata != null) {
                HiveCatalog.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
            }
            return true;
        }
        catch (NoSuchObjectException | NoSuchTableException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop " + identifier, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable", e);
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier originalTo) {
        if (!this.isValidIdentifier(from)) {
            throw new NoSuchTableException("Invalid identifier: %s", new Object[]{from});
        }
        TableIdentifier to = this.removeCatalogName(originalTo);
        Preconditions.checkArgument((boolean)this.isValidIdentifier(to), (String)"Invalid identifier: %s", (Object)to);
        String toDatabase = to.namespace().level(0);
        String fromDatabase = from.namespace().level(0);
        String fromName = from.name();
        try {
            Table table = this.clients.run(client -> client.getTable(fromDatabase, fromName));
            HiveTableOperations.validateTableIsIceberg(table, HiveCatalog.fullTableName((String)this.name, (TableIdentifier)from));
            table.setDbName(toDatabase);
            table.setTableName(to.name());
            this.clients.run(client -> {
                client.alter_table(fromDatabase, fromName, table);
                return null;
            });
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{from});
        }
        catch (org.apache.hadoop.hive.metastore.api.AlreadyExistsException e) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{to});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename " + from + " to " + to, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to rename", e);
        }
    }

    public void createNamespace(Namespace namespace, Map<String, String> meta) {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (String)"Cannot create namespace with invalid name: %s", (Object)namespace);
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Cannot support multi part namespace in Hive MetaStore: %s", (Object)namespace);
        try {
            this.clients.run(client -> {
                client.createDatabase(this.convertToDatabase(namespace, meta));
                return null;
            });
        }
        catch (org.apache.hadoop.hive.metastore.api.AlreadyExistsException e) {
            throw new AlreadyExistsException((Throwable)e, "Namespace '%s' already exists!", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create namespace " + namespace + " in Hive MataStore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to createDatabase(name) " + namespace + " in Hive MataStore", e);
        }
    }

    public List<Namespace> listNamespaces(Namespace namespace) {
        if (!this.isValidateNamespace(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        if (!namespace.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            return this.clients.run(HiveMetaStoreClient::getAllDatabases).stream().map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all namespace: " + namespace + " in Hive MataStore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getAllDatabases() " + namespace + " in Hive MataStore", e);
        }
    }

    public boolean dropNamespace(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            return false;
        }
        try {
            this.clients.run(client -> {
                client.dropDatabase(namespace.level(0), false, false, false);
                return null;
            });
            return true;
        }
        catch (InvalidOperationException e) {
            throw new NamespaceNotEmptyException("Namespace " + namespace + " is not empty. One or more tables exist.", new Object[]{e});
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop namespace " + namespace + " in Hive MataStore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to drop dropDatabase(name) " + namespace + " in Hive MataStore", e);
        }
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        HashMap parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        parameter.putAll(properties);
        Database database = this.convertToDatabase(namespace, parameter);
        return this.alterHiveDataBase(namespace, database);
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        HashMap parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        properties.forEach(key -> {
            String cfr_ignored_0 = parameter.put(key, null);
        });
        Database database = this.convertToDatabase(namespace, parameter);
        return this.alterHiveDataBase(namespace, database);
    }

    private boolean alterHiveDataBase(Namespace namespace, Database database) {
        try {
            this.clients.run(client -> {
                client.alterDatabase(namespace.level(0), database);
                return null;
            });
            return true;
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + namespace + " in Hive MataStore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + namespace + " in Hive MataStore", e);
        }
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        try {
            Database database = this.clients.run(client -> client.getDatabase(namespace.level(0)));
            return this.convertToMetadata(database);
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + namespace + " in Hive MataStore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + namespace + " in Hive MataStore", e);
        }
    }

    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        return tableIdentifier.namespace().levels().length == 1;
    }

    private TableIdentifier removeCatalogName(TableIdentifier to) {
        if (this.isValidIdentifier(to)) {
            return to;
        }
        if (to.namespace().levels().length == 2 && this.name().equalsIgnoreCase(to.namespace().level(0))) {
            return TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{to.namespace().level(1)}), (String)to.name());
        }
        return to;
    }

    private boolean isValidateNamespace(Namespace namespace) {
        return namespace.levels().length == 1;
    }

    public TableOperations newTableOps(TableIdentifier tableIdentifier) {
        String dbName = tableIdentifier.namespace().level(0);
        String tableName = tableIdentifier.name();
        return new HiveTableOperations(this.conf, this.clients, this.name, dbName, tableName);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        String warehouseLocation = this.conf.get("hive.metastore.warehouse.dir");
        Preconditions.checkNotNull((Object)warehouseLocation, (Object)"Warehouse location is not set: hive.metastore.warehouse.dir=null");
        return String.format("%s/%s.db/%s", warehouseLocation, tableIdentifier.namespace().levels()[0], tableIdentifier.name());
    }

    private Map<String, String> convertToMetadata(Database database) {
        HashMap meta = Maps.newHashMap();
        meta.putAll(database.getParameters());
        meta.put("location", database.getLocationUri());
        if (database.getDescription() != null) {
            meta.put("comment", database.getDescription());
        }
        return meta;
    }

    Database convertToDatabase(Namespace namespace, Map<String, String> meta) {
        String warehouseLocation = this.conf.get("hive.metastore.warehouse.dir");
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        Database database = new Database();
        HashMap parameter = Maps.newHashMap();
        database.setName(namespace.level(0));
        database.setLocationUri(new Path(warehouseLocation, namespace.level(0)).toString() + ".db");
        meta.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        database.setParameters((Map)parameter);
        return database;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.clients.close();
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
        }
    }
}

