/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class Event
implements IndexedRecord {
    private static final PayloadType[] PAYLOAD_TYPE_VALUES = PayloadType.values();
    private UUID id;
    private PayloadType type;
    private OffsetDateTime timestamp;
    private String groupId;
    private Payload payload;
    private final Schema avroSchema;
    static final int ID = 10500;
    static final int TYPE = 10501;
    static final int TIMESTAMP = 10502;
    static final int GROUP_ID = 10503;
    static final int PAYLOAD = 10504;

    public Event(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public Event(String groupId, Payload payload) {
        Preconditions.checkNotNull((Object)groupId, (Object)"Group ID cannot be null");
        Preconditions.checkNotNull((Object)payload, (Object)"Payload cannot be null");
        this.id = UUID.randomUUID();
        this.type = payload.type();
        this.timestamp = OffsetDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        this.groupId = groupId;
        this.payload = payload;
        Types.StructType icebergSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10500, (String)"id", (Type)Types.UUIDType.get()), Types.NestedField.required((int)10501, (String)"type", (Type)Types.IntegerType.get()), Types.NestedField.required((int)10502, (String)"timestamp", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)10503, (String)"group_id", (Type)Types.StringType.get()), Types.NestedField.required((int)10504, (String)"payload", (Type)payload.writeSchema())});
        HashMap typeMap = Maps.newHashMap(AvroUtil.FIELD_ID_TO_CLASS);
        typeMap.put(10504, payload.getClass().getName());
        this.avroSchema = AvroUtil.convert(icebergSchema, this.getClass(), typeMap);
    }

    public UUID id() {
        return this.id;
    }

    public PayloadType type() {
        return this.type;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public Payload payload() {
        return this.payload;
    }

    public String groupId() {
        return this.groupId;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10500: {
                this.id = (UUID)v;
                return;
            }
            case 10501: {
                this.type = v == null ? null : PAYLOAD_TYPE_VALUES[(Integer)v];
                return;
            }
            case 10502: {
                this.timestamp = v == null ? null : DateTimeUtil.timestamptzFromMicros((long)((Long)v));
                return;
            }
            case 10503: {
                this.groupId = v == null ? null : v.toString();
                return;
            }
            case 10504: {
                this.payload = (Payload)v;
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10500: {
                return this.id;
            }
            case 10501: {
                return this.type == null ? null : Integer.valueOf(this.type.id());
            }
            case 10502: {
                return this.timestamp == null ? null : Long.valueOf(DateTimeUtil.microsFromTimestamptz((OffsetDateTime)this.timestamp));
            }
            case 10503: {
                return this.groupId;
            }
            case 10504: {
                return this.payload;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

