/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class CommitComplete
implements Payload {
    private UUID commitId;
    private OffsetDateTime validThroughTs;
    private final Schema avroSchema;
    static final int COMMIT_ID = 10000;
    static final int VALID_THROUGH_TS = 10001;
    private static final Types.StructType ICEBERG_SCHEMA = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10000, (String)"commit_id", (Type)Types.UUIDType.get()), Types.NestedField.optional((int)10001, (String)"valid_through_ts", (Type)Types.TimestampType.withZone())});
    private static final Schema AVRO_SCHEMA = AvroUtil.convert(ICEBERG_SCHEMA, CommitComplete.class);

    public CommitComplete(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public CommitComplete(UUID commitId, OffsetDateTime validThroughTs) {
        Preconditions.checkNotNull((Object)commitId, (Object)"Commit ID cannot be null");
        this.commitId = commitId;
        this.validThroughTs = validThroughTs;
        this.avroSchema = AVRO_SCHEMA;
    }

    @Override
    public PayloadType type() {
        return PayloadType.COMMIT_COMPLETE;
    }

    public UUID commitId() {
        return this.commitId;
    }

    public OffsetDateTime validThroughTs() {
        return this.validThroughTs;
    }

    @Override
    public Types.StructType writeSchema() {
        return ICEBERG_SCHEMA;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10000: {
                this.commitId = (UUID)v;
                return;
            }
            case 10001: {
                this.validThroughTs = v == null ? null : DateTimeUtil.timestamptzFromMicros((long)((Long)v));
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10000: {
                return this.commitId;
            }
            case 10001: {
                return this.validThroughTs == null ? null : Long.valueOf(DateTimeUtil.microsFromTimestamptz((OffsetDateTime)this.validThroughTs));
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

