/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class StartCommit
implements Payload {
    private UUID commitId;
    private final Schema avroSchema;
    static final int COMMIT_ID = 10200;
    private static final Types.StructType ICEBERG_SCHEMA = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10200, (String)"commit_id", (Type)Types.UUIDType.get())});
    private static final Schema AVRO_SCHEMA = AvroUtil.convert(ICEBERG_SCHEMA, StartCommit.class);

    public StartCommit(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public StartCommit(UUID commitId) {
        Preconditions.checkNotNull((Object)commitId, (Object)"Commit ID cannot be null");
        this.commitId = commitId;
        this.avroSchema = AVRO_SCHEMA;
    }

    @Override
    public PayloadType type() {
        return PayloadType.START_COMMIT;
    }

    public UUID commitId() {
        return this.commitId;
    }

    @Override
    public Types.StructType writeSchema() {
        return ICEBERG_SCHEMA;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10200: {
                this.commitId = (UUID)v;
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10200: {
                return this.commitId;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

