/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class TableReference
implements IndexedRecord {
    private String catalog;
    private List<String> namespace;
    private String name;
    private final Schema avroSchema;
    static final int CATALOG = 10600;
    static final int NAMESPACE = 10601;
    static final int NAME = 10603;
    public static final Types.StructType ICEBERG_SCHEMA = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10600, (String)"catalog", (Type)Types.StringType.get()), Types.NestedField.required((int)10601, (String)"namespace", (Type)Types.ListType.ofRequired((int)10602, (Type)Types.StringType.get())), Types.NestedField.required((int)10603, (String)"name", (Type)Types.StringType.get())});
    private static final Schema AVRO_SCHEMA = AvroUtil.convert(ICEBERG_SCHEMA, TableReference.class);

    public static TableReference of(String catalog, TableIdentifier tableIdentifier) {
        return new TableReference(catalog, Arrays.asList(tableIdentifier.namespace().levels()), tableIdentifier.name());
    }

    public TableReference(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public TableReference(String catalog, List<String> namespace, String name) {
        Preconditions.checkNotNull((Object)catalog, (Object)"Catalog cannot be null");
        Preconditions.checkNotNull(namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.catalog = catalog;
        this.namespace = namespace;
        this.name = name;
        this.avroSchema = AVRO_SCHEMA;
    }

    public String catalog() {
        return this.catalog;
    }

    public TableIdentifier identifier() {
        Namespace icebergNamespace = Namespace.of((String[])this.namespace.toArray(new String[0]));
        return TableIdentifier.of((Namespace)icebergNamespace, (String)this.name);
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10600: {
                this.catalog = v == null ? null : v.toString();
                return;
            }
            case 10601: {
                this.namespace = v == null ? null : ((List)v).stream().map(Utf8::toString).collect(Collectors.toList());
                return;
            }
            case 10603: {
                this.name = v == null ? null : v.toString();
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10600: {
                return this.catalog;
            }
            case 10601: {
                return this.namespace;
            }
            case 10603: {
                return this.name;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableReference that = (TableReference)o;
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.namespace, this.name);
    }
}

