/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.time.OffsetDateTime;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class TopicPartitionOffset
implements IndexedRecord {
    private String topic;
    private Integer partition;
    private Long offset;
    private OffsetDateTime timestamp;
    private final Schema avroSchema;
    static final int TOPIC = 10700;
    static final int PARTITION = 10701;
    static final int OFFSET = 10702;
    static final int TIMESTAMP = 10703;
    public static final Types.StructType ICEBERG_SCHEMA = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10700, (String)"topic", (Type)Types.StringType.get()), Types.NestedField.required((int)10701, (String)"partition", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)10702, (String)"offset", (Type)Types.LongType.get()), Types.NestedField.optional((int)10703, (String)"timestamp", (Type)Types.TimestampType.withZone())});
    private static final Schema AVRO_SCHEMA = AvroUtil.convert(ICEBERG_SCHEMA, TopicPartitionOffset.class);

    public TopicPartitionOffset(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public TopicPartitionOffset(String topic, int partition, Long offset, OffsetDateTime timestamp) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic cannot be null");
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
        this.avroSchema = AVRO_SCHEMA;
    }

    public String topic() {
        return this.topic;
    }

    public Integer partition() {
        return this.partition;
    }

    public Long offset() {
        return this.offset;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10700: {
                this.topic = v == null ? null : v.toString();
                return;
            }
            case 10701: {
                this.partition = (Integer)v;
                return;
            }
            case 10702: {
                this.offset = (Long)v;
                return;
            }
            case 10703: {
                this.timestamp = v == null ? null : DateTimeUtil.timestamptzFromMicros((long)((Long)v));
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10700: {
                return this.topic;
            }
            case 10701: {
                return this.partition;
            }
            case 10702: {
                return this.offset;
            }
            case 10703: {
                return this.timestamp == null ? null : Long.valueOf(DateTimeUtil.microsFromTimestamptz((OffsetDateTime)this.timestamp));
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

