/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.connect.events.TableReference;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class CommitToTable
implements Payload {
    private UUID commitId;
    private TableReference tableReference;
    private Long snapshotId;
    private OffsetDateTime validThroughTs;
    private final Schema avroSchema;
    static final int COMMIT_ID = 10400;
    static final int TABLE_REFERENCE = 10401;
    static final int SNAPSHOT_ID = 10402;
    static final int VALID_THROUGH_TS = 10403;
    private static final Types.StructType ICEBERG_SCHEMA = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10400, (String)"commit_id", (Type)Types.UUIDType.get()), Types.NestedField.required((int)10401, (String)"table_reference", (Type)TableReference.ICEBERG_SCHEMA), Types.NestedField.optional((int)10402, (String)"snapshot_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)10403, (String)"valid_through_ts", (Type)Types.TimestampType.withZone())});
    private static final Schema AVRO_SCHEMA = AvroUtil.convert(ICEBERG_SCHEMA, CommitToTable.class);

    public CommitToTable(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public CommitToTable(UUID commitId, TableReference tableReference, Long snapshotId, OffsetDateTime validThroughTs) {
        Preconditions.checkNotNull((Object)commitId, (Object)"Commit ID cannot be null");
        Preconditions.checkNotNull((Object)tableReference, (Object)"Table reference cannot be null");
        this.commitId = commitId;
        this.tableReference = tableReference;
        this.snapshotId = snapshotId;
        this.validThroughTs = validThroughTs;
        this.avroSchema = AVRO_SCHEMA;
    }

    @Override
    public PayloadType type() {
        return PayloadType.COMMIT_TO_TABLE;
    }

    public UUID commitId() {
        return this.commitId;
    }

    public TableReference tableReference() {
        return this.tableReference;
    }

    public Long snapshotId() {
        return this.snapshotId;
    }

    public OffsetDateTime validThroughTs() {
        return this.validThroughTs;
    }

    @Override
    public Types.StructType writeSchema() {
        return ICEBERG_SCHEMA;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10400: {
                this.commitId = (UUID)v;
                return;
            }
            case 10401: {
                this.tableReference = (TableReference)v;
                return;
            }
            case 10402: {
                this.snapshotId = (Long)v;
                return;
            }
            case 10403: {
                this.validThroughTs = v == null ? null : DateTimeUtil.timestamptzFromMicros((long)((Long)v));
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10400: {
                return this.commitId;
            }
            case 10401: {
                return this.tableReference;
            }
            case 10402: {
                return this.snapshotId;
            }
            case 10403: {
                return this.validThroughTs == null ? null : Long.valueOf(DateTimeUtil.microsFromTimestamptz((OffsetDateTime)this.validThroughTs));
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

