/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.connect.IcebergSinkTask;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;

public class IcebergSinkConnector
extends SinkConnector {
    private Map<String, String> props;

    public String version() {
        return IcebergSinkConfig.version();
    }

    public void start(Map<String, String> connectorProps) {
        this.props = connectorProps;
    }

    public Class<? extends Task> taskClass() {
        return IcebergSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        String txnSuffix = "-txn-" + UUID.randomUUID() + "-";
        return IntStream.range(0, maxTasks).mapToObj(i -> {
            HashMap map = Maps.newHashMap(this.props);
            map.put("iceberg.coordinator.transactional.suffix", txnSuffix + i);
            return map;
        }).collect(Collectors.toList());
    }

    public void stop() {
    }

    public ConfigDef config() {
        return IcebergSinkConfig.CONFIG_DEF;
    }
}

