/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.channel;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

class KafkaClientFactory {
    private final Map<String, String> kafkaProps;

    KafkaClientFactory(Map<String, String> kafkaProps) {
        this.kafkaProps = kafkaProps;
    }

    Producer<String, byte[]> createProducer(String transactionalId) {
        HashMap producerProps = Maps.newHashMap(this.kafkaProps);
        producerProps.putIfAbsent("client.id", UUID.randomUUID().toString());
        producerProps.put("transactional.id", transactionalId);
        KafkaProducer result = new KafkaProducer((Map)producerProps, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
        result.initTransactions();
        return result;
    }

    Consumer<String, byte[]> createConsumer(String consumerGroupId) {
        HashMap consumerProps = Maps.newHashMap(this.kafkaProps);
        consumerProps.putIfAbsent("auto.offset.reset", "latest");
        consumerProps.putIfAbsent("client.id", UUID.randomUUID().toString());
        consumerProps.put("enable.auto.commit", false);
        consumerProps.put("isolation.level", "read_committed");
        consumerProps.put("group.id", consumerGroupId);
        return new KafkaConsumer((Map)consumerProps, (Deserializer)new StringDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    Admin createAdmin() {
        HashMap adminProps = Maps.newHashMap(this.kafkaProps);
        return Admin.create((Map)adminProps);
    }
}

