/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.channel;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.apache.iceberg.common.DynFields;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkTaskContext;

class KafkaUtils {
    private static final String CONTEXT_CLASS_NAME = "org.apache.kafka.connect.runtime.WorkerSinkTaskContext";

    static ConsumerGroupDescription consumerGroupDescription(String consumerGroupId, Admin admin) {
        try {
            DescribeConsumerGroupsResult result = admin.describeConsumerGroups((Collection)ImmutableList.of((Object)consumerGroupId));
            return (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(consumerGroupId)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ConnectException("Cannot retrieve members for consumer group: " + consumerGroupId, (Throwable)e);
        }
    }

    static ConsumerGroupMetadata consumerGroupMetadata(SinkTaskContext context) {
        return KafkaUtils.kafkaConsumer(context).groupMetadata();
    }

    private static Consumer<byte[], byte[]> kafkaConsumer(SinkTaskContext context) {
        String contextClassName = context.getClass().getName();
        try {
            return (Consumer)DynFields.builder().hiddenImpl(CONTEXT_CLASS_NAME, "consumer").build((Object)context).get();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to retrieve consumer from context: " + contextClassName, (Throwable)e);
        }
    }

    private KafkaUtils() {
    }
}

