/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.data;

import java.util.Collection;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;

class SchemaUpdate {
    SchemaUpdate() {
    }

    static class MakeOptional
    extends SchemaUpdate {
        private final String name;

        MakeOptional(String name) {
            this.name = name;
        }

        String name() {
            return this.name;
        }
    }

    static class UpdateType
    extends SchemaUpdate {
        private final String name;
        private final Type.PrimitiveType type;

        UpdateType(String name, Type.PrimitiveType type) {
            this.name = name;
            this.type = type;
        }

        String name() {
            return this.name;
        }

        Type.PrimitiveType type() {
            return this.type;
        }
    }

    static class AddColumn
    extends SchemaUpdate {
        private final String parentName;
        private final String name;
        private final Type type;

        AddColumn(String parentName, String name, Type type) {
            this.parentName = parentName;
            this.name = name;
            this.type = type;
        }

        String parentName() {
            return this.parentName;
        }

        String name() {
            return this.name;
        }

        String key() {
            return this.parentName == null ? this.name : this.parentName + "." + this.name;
        }

        Type type() {
            return this.type;
        }
    }

    static class Consumer {
        private final Map<String, AddColumn> addColumns = Maps.newHashMap();
        private final Map<String, UpdateType> updateTypes = Maps.newHashMap();
        private final Map<String, MakeOptional> makeOptionals = Maps.newHashMap();

        Consumer() {
        }

        Collection<AddColumn> addColumns() {
            return this.addColumns.values();
        }

        Collection<UpdateType> updateTypes() {
            return this.updateTypes.values();
        }

        Collection<MakeOptional> makeOptionals() {
            return this.makeOptionals.values();
        }

        boolean empty() {
            return this.addColumns.isEmpty() && this.updateTypes.isEmpty() && this.makeOptionals.isEmpty();
        }

        void addColumn(String parentName, String name, Type type) {
            AddColumn addCol = new AddColumn(parentName, name, type);
            this.addColumns.put(addCol.key(), addCol);
        }

        void updateType(String name, Type.PrimitiveType type) {
            this.updateTypes.put(name, new UpdateType(name, type));
        }

        void makeOptional(String name) {
            this.makeOptionals.put(name, new MakeOptional(name));
        }
    }
}

