/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CatalogUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)CatalogUtils.class.getName());
    private static final List<String> HADOOP_CONF_FILES = ImmutableList.of((Object)"core-site.xml", (Object)"hdfs-site.xml", (Object)"hive-site.xml");

    static Catalog loadCatalog(IcebergSinkConfig config) {
        return CatalogUtil.buildIcebergCatalog((String)config.catalogName(), config.catalogProps(), (Object)CatalogUtils.loadHadoopConfig(config));
    }

    private static Object loadHadoopConfig(IcebergSinkConfig config) {
        Class configClass = DynClasses.builder().impl("org.apache.hadoop.hdfs.HdfsConfiguration").impl("org.apache.hadoop.conf.Configuration").orNull().build();
        if (configClass == null) {
            LOG.info("Hadoop not found on classpath, not creating Hadoop config");
            return null;
        }
        try {
            Object result = DynConstructors.builder().hiddenImpl(configClass, new Class[0]).build().newInstance(new Object[0]);
            DynMethods.BoundMethod addResourceMethod = DynMethods.builder((String)"addResource").impl(configClass, new Class[]{URL.class}).build(result);
            DynMethods.BoundMethod setMethod = DynMethods.builder((String)"set").impl(configClass, new Class[]{String.class, String.class}).build(result);
            String hadoopConfDir = config.hadoopConfDir();
            if (hadoopConfDir != null) {
                HADOOP_CONF_FILES.forEach(confFile -> {
                    Path path = Paths.get(hadoopConfDir, confFile);
                    if (Files.exists(path, new LinkOption[0])) {
                        try {
                            addResourceMethod.invoke(new Object[]{path.toUri().toURL()});
                        }
                        catch (IOException e) {
                            LOG.warn("Error adding Hadoop resource {}, resource was not added", (Object)path, (Object)e);
                        }
                    }
                });
            }
            config.hadoopProps().forEach((xva$0, xva$1) -> setMethod.invoke(new Object[]{xva$0, xva$1}));
            LOG.info("Hadoop config initialized: {}", (Object)configClass.getName());
            return result;
        }
        catch (Exception e) {
            LOG.warn("Hadoop found on classpath but could not create config, proceeding without config", (Throwable)e);
            return null;
        }
    }

    private CatalogUtils() {
    }
}

