/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect;

import java.util.Collection;
import java.util.Map;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.connect.CatalogUtils;
import org.apache.iceberg.connect.Committer;
import org.apache.iceberg.connect.CommitterFactory;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergSinkTask
extends SinkTask {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergSinkTask.class);
    private IcebergSinkConfig config;
    private Catalog catalog;
    private Committer committer;

    public String version() {
        return IcebergSinkConfig.version();
    }

    public void start(Map<String, String> props) {
        this.config = new IcebergSinkConfig(props);
        this.catalog = CatalogUtils.loadCatalog(this.config);
        this.committer = CommitterFactory.createCommitter(this.config);
    }

    public void open(Collection<TopicPartition> partitions) {
        this.committer.open(this.catalog, this.config, this.context, partitions);
    }

    public void close(Collection<TopicPartition> partitions) {
        this.committer.close(partitions);
    }

    private void close() {
        if (this.committer != null) {
            this.committer.close(this.context.assignment());
            this.committer = null;
        }
        if (this.catalog != null) {
            if (this.catalog instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)this.catalog).close();
                }
                catch (Exception e) {
                    LOG.warn("An error occurred closing catalog instance, ignoring...", (Throwable)e);
                }
            }
            this.catalog = null;
        }
    }

    public void put(Collection<SinkRecord> sinkRecords) {
        if (this.committer != null) {
            this.committer.save(sinkRecords);
        }
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        if (this.committer != null) {
            this.committer.save(null);
        }
    }

    public Map<TopicPartition, OffsetAndMetadata> preCommit(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        return ImmutableMap.of();
    }

    public void stop() {
        this.close();
    }
}

