/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.channel;

import org.apache.iceberg.connect.channel.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CoordinatorThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorThread.class);
    private static final String THREAD_NAME = "iceberg-coord";
    private final Coordinator coordinator;
    private volatile boolean terminated;

    CoordinatorThread(Coordinator coordinator) {
        super(THREAD_NAME);
        this.coordinator = coordinator;
    }

    @Override
    public void run() {
        try {
            this.coordinator.start();
        }
        catch (Exception e) {
            LOG.error("Coordinator error during start, exiting thread", (Throwable)e);
            this.terminated = true;
        }
        while (!this.terminated) {
            try {
                this.coordinator.process();
            }
            catch (Exception e) {
                LOG.error("Coordinator error during process, exiting thread", (Throwable)e);
                this.terminated = true;
            }
        }
        try {
            this.coordinator.stop();
        }
        catch (Exception e) {
            LOG.error("Coordinator error during stop, ignoring", (Throwable)e);
        }
    }

    boolean isTerminated() {
        return this.terminated;
    }

    void terminate() {
        this.terminated = true;
        this.coordinator.terminate();
    }
}

