/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.channel;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.iceberg.common.DynFields;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaUtils.class);
    private static final String CONTEXT_CLASS_NAME = "org.apache.kafka.connect.runtime.WorkerSinkTaskContext";

    static ConsumerGroupDescription consumerGroupDescription(String consumerGroupId, Admin admin) {
        try {
            DescribeConsumerGroupsResult result = admin.describeConsumerGroups((Collection)ImmutableList.of((Object)consumerGroupId));
            return (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(consumerGroupId)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ConnectException("Cannot retrieve members for consumer group: " + consumerGroupId, (Throwable)e);
        }
    }

    static ConsumerGroupMetadata consumerGroupMetadata(SinkTaskContext context) {
        return KafkaUtils.kafkaConsumer(context).groupMetadata();
    }

    static void seekToLastCommittedOffsets(SinkTaskContext context) {
        Consumer<byte[], byte[]> consumer = KafkaUtils.kafkaConsumer(context);
        if (consumer == null) {
            return;
        }
        Map committedOffsets = consumer.committed(consumer.assignment());
        if (committedOffsets == null || committedOffsets.isEmpty()) {
            return;
        }
        committedOffsets.forEach((topicPartition, offsetAndMetadata) -> {
            if (offsetAndMetadata != null) {
                try {
                    consumer.seek(topicPartition, offsetAndMetadata.offset());
                }
                catch (IllegalStateException e) {
                    LOG.warn("Rebalance may have occurred, partition {} lost before seeking", topicPartition, (Object)e);
                }
            }
        });
    }

    private static Consumer<byte[], byte[]> kafkaConsumer(SinkTaskContext context) {
        String contextClassName = context.getClass().getName();
        try {
            return (Consumer)DynFields.builder().hiddenImpl(CONTEXT_CLASS_NAME, "consumer").build((Object)context).get();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to retrieve consumer from context: " + contextClassName, (Throwable)e);
        }
    }

    private KafkaUtils() {
    }
}

