/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.connect.data.PartitionedAppendWriter;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.primitives.Ints;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;

class RecordUtils {
    static Object extractFromRecordValue(Object recordValue, String fieldName) {
        List fields = Splitter.on((char)'.').splitToList((CharSequence)fieldName);
        if (recordValue instanceof Struct) {
            return RecordUtils.valueFromStruct((Struct)recordValue, fields);
        }
        if (recordValue instanceof Map) {
            return RecordUtils.valueFromMap((Map)recordValue, fields);
        }
        throw new UnsupportedOperationException("Cannot extract value from type: " + recordValue.getClass().getName());
    }

    private static Object valueFromStruct(Struct parent, List<String> fields) {
        Struct struct = parent;
        for (int idx = 0; idx < fields.size() - 1; ++idx) {
            Object value = RecordUtils.fieldValueFromStruct(struct, fields.get(idx));
            if (value == null) {
                return null;
            }
            Preconditions.checkState((boolean)(value instanceof Struct), (Object)"Expected a struct type");
            struct = (Struct)value;
        }
        return RecordUtils.fieldValueFromStruct(struct, fields.get(fields.size() - 1));
    }

    private static Object fieldValueFromStruct(Struct struct, String fieldName) {
        Field structField = struct.schema().field(fieldName);
        if (structField == null) {
            return null;
        }
        return struct.get(structField);
    }

    private static Object valueFromMap(Map<String, ?> parent, List<String> fields) {
        Map map = parent;
        for (int idx = 0; idx < fields.size() - 1; ++idx) {
            Object value = map.get(fields.get(idx));
            if (value == null) {
                return null;
            }
            Preconditions.checkState((boolean)(value instanceof Map), (Object)"Expected a map type");
            map = (Map)value;
        }
        return map.get(fields.get(fields.size() - 1));
    }

    public static TaskWriter<Record> createTableWriter(Table table, String tableName, IcebergSinkConfig config) {
        HashMap tableProps = Maps.newHashMap((Map)table.properties());
        tableProps.putAll(config.writeProps());
        String formatStr = tableProps.getOrDefault("write.format.default", "parquet");
        FileFormat format = FileFormat.fromString((String)formatStr);
        long targetFileSize = PropertyUtil.propertyAsLong((Map)tableProps, (String)"write.target-file-size-bytes", (long)0x20000000L);
        Set identifierFieldIds = table.schema().identifierFieldIds();
        List<String> idCols = config.tableConfig(tableName).idColumns();
        if (!idCols.isEmpty()) {
            identifierFieldIds = idCols.stream().map(colName -> {
                Types.NestedField field = table.schema().findField(colName);
                if (field == null) {
                    throw new IllegalArgumentException("ID column not found: " + colName);
                }
                return field.fieldId();
            }).collect(Collectors.toSet());
        }
        GenericAppenderFactory appenderFactory = identifierFieldIds == null || identifierFieldIds.isEmpty() ? new GenericAppenderFactory(table.schema(), table.spec(), null, null, null).setAll((Map)tableProps) : new GenericAppenderFactory(table.schema(), table.spec(), Ints.toArray(identifierFieldIds), TypeUtil.select((Schema)table.schema(), (Set)Sets.newHashSet(identifierFieldIds)), null).setAll((Map)tableProps);
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)1, (long)System.currentTimeMillis()).defaultSpec(table.spec()).operationId(UUID.randomUUID().toString()).format(format).build();
        Object writer = table.spec().isUnpartitioned() ? new UnpartitionedWriter(table.spec(), format, (FileAppenderFactory)appenderFactory, fileFactory, table.io(), targetFileSize) : new PartitionedAppendWriter(table.spec(), format, (FileAppenderFactory<Record>)appenderFactory, fileFactory, table.io(), targetFileSize, table.schema());
        return writer;
    }

    private RecordUtils() {
    }
}

