/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.Map;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.UpdateableReference;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private final NessieClient client;
    private final ContentsKey key;
    private UpdateableReference reference;
    private IcebergTable table;
    private FileIO fileIO;
    private Map<String, String> catalogOptions;

    NessieTableOperations(ContentsKey key, UpdateableReference reference, NessieClient client, FileIO fileIO, Map<String, String> catalogOptions) {
        this.key = key;
        this.reference = reference;
        this.client = client;
        this.fileIO = fileIO;
        this.catalogOptions = catalogOptions;
    }

    protected String tableName() {
        return this.key.toString();
    }

    protected void doRefresh() {
        String metadataLocation;
        block4: {
            try {
                this.reference.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException("Failed to refresh as ref is no longer valid.", e);
            }
            metadataLocation = null;
            try {
                Contents contents = this.client.getContentsApi().getContents(this.key, this.reference.getName(), this.reference.getHash());
                this.table = (IcebergTable)contents.unwrap(IcebergTable.class).orElseThrow(() -> new IllegalStateException("Cannot refresh iceberg table: " + String.format("Nessie points to a non-Iceberg object for path: %s.", this.key)));
                metadataLocation = this.table.getMetadataLocation();
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block4;
                throw new NoSuchTableException((Throwable)ex, "No such table %s", new Object[]{this.key});
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, 2);
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        this.reference.checkMutable();
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        boolean delete = true;
        try {
            ImmutableIcebergTable.Builder newTable = ImmutableIcebergTable.builder();
            if (this.table != null) {
                newTable.from(this.table);
            }
            newTable.metadataLocation(newMetadataLocation);
            ImmutableOperations op = ImmutableOperations.builder().addOperations((Operation)Operation.Put.of((ContentsKey)this.key, (Contents)newTable.build())).commitMeta(NessieUtil.buildCommitMetadata("iceberg commit", this.catalogOptions)).build();
            Branch branch = this.client.getTreeApi().commitMultipleOperations(this.reference.getAsBranch().getName(), this.reference.getHash(), (Operations)op);
            this.reference.updateReference((Reference)branch);
            delete = false;
        }
        catch (NessieConflictException ex) {
            throw new CommitFailedException((Throwable)ex, "Commit failed: Reference hash is out of date. Update the reference %s and try again", new Object[]{this.reference.getName()});
        }
        catch (HttpClientException ex) {
            delete = false;
            throw new CommitStateUnknownException((Throwable)ex);
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(String.format("Commit failed: Reference %s no longer exist", this.reference.getName()), ex);
        }
        finally {
            if (delete) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    public FileIO io() {
        return this.fileIO;
    }
}

