/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableCommitMeta;

public final class NessieUtil {
    static final String APPLICATION_TYPE = "application-type";

    private NessieUtil() {
    }

    static Predicate<EntriesResponse.Entry> namespacePredicate(Namespace ns) {
        if (ns == null) {
            return e -> true;
        }
        List<String> namespace = Arrays.asList(ns.levels());
        Predicate<EntriesResponse.Entry> predicate = e -> {
            List names = e.getName().getElements();
            if (names.size() <= namespace.size()) {
                return false;
            }
            return namespace.equals(names.subList(0, namespace.size()));
        };
        return predicate;
    }

    static TableIdentifier toIdentifier(EntriesResponse.Entry entry) {
        List elements = entry.getName().getElements();
        return TableIdentifier.of((String[])elements.toArray(new String[elements.size()]));
    }

    static TableIdentifier removeCatalogName(TableIdentifier to, String name) {
        String[] levels = to.namespace().levels();
        if (levels.length >= 2 && name.equalsIgnoreCase(to.namespace().level(0))) {
            Namespace trimmedNamespace = Namespace.of((String[])Arrays.copyOfRange(levels, 1, levels.length));
            return TableIdentifier.of((Namespace)trimmedNamespace, (String)to.name());
        }
        return to;
    }

    static ContentsKey toKey(TableIdentifier tableIdentifier) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (tableIdentifier.hasNamespace()) {
            identifiers.addAll(Arrays.asList(tableIdentifier.namespace().levels()));
        }
        identifiers.add(tableIdentifier.name());
        ContentsKey key = ContentsKey.of(identifiers);
        return key;
    }

    static CommitMeta buildCommitMetadata(String commitMsg, Map<String, String> catalogOptions) {
        Preconditions.checkArgument((null != catalogOptions ? 1 : 0) != 0, (Object)"catalogOptions must not be null");
        ImmutableCommitMeta.Builder cm = CommitMeta.builder().message(commitMsg).author(NessieUtil.commitAuthor(catalogOptions));
        cm.putProperties(APPLICATION_TYPE, "iceberg");
        if (catalogOptions.containsKey("app-id")) {
            cm.putProperties("app-id", catalogOptions.get("app-id"));
        }
        return cm.build();
    }

    @Nullable
    private static String commitAuthor(Map<String, String> catalogOptions) {
        return Optional.ofNullable(catalogOptions.get("user")).orElseGet(() -> System.getProperty("user.name"));
    }
}

