/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.time.Instant;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;

public class TableReference {
    private static final Splitter BRANCH_NAME_SPLITTER = Splitter.on((String)"@");
    private final TableIdentifier tableIdentifier;
    private final Instant timestamp;
    private final String reference;

    public TableReference(TableIdentifier tableIdentifier, Instant timestamp, String reference) {
        this.tableIdentifier = tableIdentifier;
        this.timestamp = timestamp;
        this.reference = reference;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String reference() {
        return this.reference;
    }

    public static TableReference parse(TableIdentifier path) {
        TableReference pti = TableReference.parse(path.name());
        return new TableReference(TableIdentifier.of((Namespace)path.namespace(), (String)pti.tableIdentifier().name()), pti.timestamp(), pti.reference());
    }

    public static TableReference parse(String path) {
        if (path.split("@").length > 2) {
            throw new IllegalArgumentException(String.format("Can only reference one branch in %s", path));
        }
        if (path.split("#").length > 2) {
            throw new IllegalArgumentException(String.format("Can only reference one timestamp in %s", path));
        }
        if (path.contains("@") && path.contains("#")) {
            throw new IllegalArgumentException("Invalid table name: # is not allowed (reference by timestamp is not supported)");
        }
        if (path.contains("@")) {
            List tableRef = BRANCH_NAME_SPLITTER.splitToList((CharSequence)path);
            TableIdentifier identifier = TableIdentifier.parse((String)((String)tableRef.get(0)));
            return new TableReference(identifier, null, (String)tableRef.get(1));
        }
        if (path.contains("#")) {
            throw new IllegalArgumentException("Invalid table name: # is not allowed (reference by timestamp is not supported)");
        }
        TableIdentifier identifier = TableIdentifier.parse((String)path);
        return new TableReference(identifier, null, null);
    }
}

