/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.JsonUtil;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableCommitMeta;

public final class NessieUtil {
    public static final String NESSIE_CONFIG_PREFIX = "nessie.";
    static final String APPLICATION_TYPE = "application-type";

    private NessieUtil() {
    }

    static TableIdentifier removeCatalogName(TableIdentifier to, String name) {
        String[] levels = to.namespace().levels();
        if (levels.length >= 2 && name.equalsIgnoreCase(to.namespace().level(0))) {
            Namespace trimmedNamespace = Namespace.of((String[])Arrays.copyOfRange(levels, 1, levels.length));
            return TableIdentifier.of((Namespace)trimmedNamespace, (String)to.name());
        }
        return to;
    }

    static ContentKey toKey(TableIdentifier tableIdentifier) {
        ArrayList identifiers = Lists.newArrayList();
        if (tableIdentifier.hasNamespace()) {
            identifiers.addAll(Arrays.asList(tableIdentifier.namespace().levels()));
        }
        identifiers.add(tableIdentifier.name());
        return ContentKey.of((List)identifiers);
    }

    static CommitMeta buildCommitMetadata(String commitMsg, Map<String, String> catalogOptions) {
        return NessieUtil.catalogOptions(CommitMeta.builder().message(commitMsg), catalogOptions).build();
    }

    static ImmutableCommitMeta.Builder catalogOptions(ImmutableCommitMeta.Builder commitMetaBuilder, Map<String, String> catalogOptions) {
        Preconditions.checkArgument((null != catalogOptions ? 1 : 0) != 0, (Object)"catalogOptions must not be null");
        commitMetaBuilder.author(NessieUtil.commitAuthor(catalogOptions));
        commitMetaBuilder.putProperties(APPLICATION_TYPE, "iceberg");
        if (catalogOptions.containsKey("app-id")) {
            commitMetaBuilder.putProperties("app-id", catalogOptions.get("app-id"));
        }
        return commitMetaBuilder;
    }

    @Nullable
    private static String commitAuthor(Map<String, String> catalogOptions) {
        return Optional.ofNullable(catalogOptions.get("user")).orElseGet(() -> System.getProperty("user.name"));
    }

    static TableMetadata tableMetadataFromIcebergTable(FileIO io, IcebergTable table, String metadataLocation) {
        TableMetadata deserialized;
        if (table.getMetadata() != null) {
            String jsonString;
            try (StringWriter writer = new StringWriter();){
                try (JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);){
                    generator.writeObject((Object)table.getMetadata().getMetadata());
                }
                jsonString = writer.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to generate JSON string from metadata", e);
            }
            deserialized = TableMetadataParser.fromJson((String)metadataLocation, (String)jsonString);
        } else {
            deserialized = TableMetadataParser.read((FileIO)io, (String)metadataLocation);
        }
        return deserialized;
    }

    static JsonNode tableMetadataAsJsonNode(TableMetadata metadata) {
        JsonNode newMetadata;
        try {
            String jsonString = TableMetadataParser.toJson((TableMetadata)metadata);
            try (JsonParser parser = JsonUtil.factory().createParser(jsonString);){
                newMetadata = (JsonNode)parser.readValueAs(JsonNode.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return newMetadata;
    }
}

