/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.nessie.NessieTableOperations;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.NessieViewOperations;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.view.BaseMetastoreViewCatalog;
import org.apache.iceberg.view.ViewOperations;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.projectnessie.client.config.NessieClientConfigSources;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.TableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieCatalog
extends BaseMetastoreViewCatalog
implements SupportsNamespaces,
Configurable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(NessieCatalog.class);
    private static final Joiner SLASH = Joiner.on((String)"/");
    private static final String NAMESPACE_LOCATION_PROPS = "location";
    private static final Map<String, String> DEFAULT_CATALOG_OPTIONS = ImmutableMap.builder().put((Object)"table-default.gc.enabled", (Object)"false").put((Object)"table-default.write.metadata.delete-after-commit.enabled", (Object)"false").build();
    private NessieIcebergClient client;
    private String warehouseLocation;
    private Object config;
    private String name;
    private FileIO fileIO;
    private Map<String, String> catalogOptions = DEFAULT_CATALOG_OPTIONS;
    private CloseableGroup closeableGroup;

    public void initialize(String name, Map<String, String> options) {
        NessieApiV1 api;
        ImmutableMap catalogOptions = ImmutableMap.copyOf(options);
        String fileIOImpl = options.getOrDefault("io-impl", "org.apache.iceberg.hadoop.HadoopFileIO");
        Function<String, String> removePrefix = x -> x.replace("nessie.", "");
        String requestedRef = options.get(removePrefix.apply("nessie.ref"));
        String requestedHash = options.get(removePrefix.apply("nessie.ref.hash"));
        NessieClientConfigSource configSource = NessieClientConfigSources.mapConfigSource(options).fallbackTo(x -> (String)options.get(removePrefix.apply(x)));
        NessieClientBuilder nessieClientBuilder = NessieClientBuilder.createClientBuilderFromSystemSettings((NessieClientConfigSource)configSource);
        String apiVersion = options.get(removePrefix.apply("nessie.client-api-version"));
        if (apiVersion == null) {
            apiVersion = NessieCatalog.inferVersionFromURI(options.get("uri"));
        }
        switch (apiVersion) {
            case "1": {
                api = (NessieApiV1)nessieClientBuilder.build(NessieApiV1.class);
                break;
            }
            case "2": {
                api = (NessieApiV1)nessieClientBuilder.build(NessieApiV2.class);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported %s: %s. Can only be 1 or 2", removePrefix.apply("nessie.client-api-version"), apiVersion));
            }
        }
        this.initialize(name, new NessieIcebergClient(api, requestedRef, requestedHash, (Map<String, String>)catalogOptions), CatalogUtil.loadFileIO((String)fileIOImpl, options, (Object)this.config), (Map<String, String>)catalogOptions);
    }

    private static String inferVersionFromURI(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is not specified in the catalog properties");
        }
        Pattern pattern = Pattern.compile("/v(\\d+)$");
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException(String.format("URI doesn't end with the version: %s. Please configure `client-api-version` in the catalog properties explicitly.", uri));
    }

    public void initialize(String name, NessieIcebergClient client, FileIO fileIO, Map<String, String> catalogOptions) {
        this.name = name == null ? "nessie" : name;
        this.client = (NessieIcebergClient)Preconditions.checkNotNull((Object)client, (Object)"client must be non-null");
        this.fileIO = (FileIO)Preconditions.checkNotNull((Object)fileIO, (Object)"fileIO must be non-null");
        this.catalogOptions = ImmutableMap.builder().putAll(DEFAULT_CATALOG_OPTIONS).putAll((Map)Preconditions.checkNotNull(catalogOptions, (Object)"catalogOptions must be non-null")).buildKeepingLast();
        this.warehouseLocation = this.warehouseLocation(name, catalogOptions);
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((AutoCloseable)client);
        this.closeableGroup.addCloseable((Closeable)fileIO);
        this.closeableGroup.addCloseable((Closeable)this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
    }

    private String warehouseLocation(String name, Map<String, String> catalogOptions) {
        String warehouseLocation = catalogOptions.get("warehouse");
        if (warehouseLocation == null) {
            LOG.warn("Catalog creation for inputName={} and options {} failed, because parameter 'warehouse' is not set, Nessie can't store data.", (Object)name, catalogOptions);
            throw new IllegalStateException("Parameter 'warehouse' not set, Nessie can't store data.");
        }
        return LocationUtil.stripTrailingSlash((String)warehouseLocation);
    }

    public void close() throws IOException {
        if (null != this.closeableGroup) {
            this.closeableGroup.close();
        }
    }

    public String name() {
        return this.name;
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        TableReference tr = this.parseTableReference(tableIdentifier);
        return new NessieTableOperations(ContentKey.of((Namespace)Namespace.of((String[])tableIdentifier.namespace().levels()), (String)tr.getName()), this.client.withReference(tr.getReference(), tr.getHash()), this.fileIO);
    }

    protected String defaultWarehouseLocation(TableIdentifier table) {
        String location;
        if (table.hasNamespace()) {
            String baseLocation = SLASH.join((Object)this.warehouseLocation, (Object)table.namespace().toString(), new Object[0]);
            try {
                baseLocation = this.loadNamespaceMetadata(table.namespace()).getOrDefault(NAMESPACE_LOCATION_PROPS, baseLocation);
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {
                // empty catch block
            }
            location = SLASH.join((Object)baseLocation, (Object)table.name(), new Object[0]);
        } else {
            location = SLASH.join((Object)this.warehouseLocation, (Object)table.name(), new Object[0]);
        }
        return location + "_" + String.valueOf(UUID.randomUUID());
    }

    public List<TableIdentifier> listTables(org.apache.iceberg.catalog.Namespace namespace) {
        return this.client.listTables(namespace);
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        TableReference tableReference = this.parseTableReference(identifier);
        return this.client.withReference(tableReference.getReference(), tableReference.getHash()).dropTable(this.identifierWithoutTableReference(identifier, tableReference), purge);
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        TableReference fromTableReference = this.parseTableReference(from);
        TableReference toTableReference = this.parseTableReference(to);
        this.validateReferenceForRename(fromTableReference, toTableReference, Content.Type.ICEBERG_TABLE);
        TableIdentifier fromIdentifier = NessieUtil.removeCatalogName(this.identifierWithoutTableReference(from, fromTableReference), this.name());
        TableIdentifier toIdentifier = NessieUtil.removeCatalogName(this.identifierWithoutTableReference(to, toTableReference), this.name());
        this.client.withReference(fromTableReference.getReference(), fromTableReference.getHash()).renameTable(fromIdentifier, toIdentifier);
    }

    public void createNamespace(org.apache.iceberg.catalog.Namespace namespace, Map<String, String> metadata) {
        this.client.createNamespace(namespace, metadata);
    }

    public List<org.apache.iceberg.catalog.Namespace> listNamespaces(org.apache.iceberg.catalog.Namespace namespace) throws NoSuchNamespaceException {
        return this.client.listNamespaces(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(org.apache.iceberg.catalog.Namespace namespace) throws NoSuchNamespaceException {
        return this.client.loadNamespaceMetadata(namespace);
    }

    public boolean dropNamespace(org.apache.iceberg.catalog.Namespace namespace) throws NamespaceNotEmptyException {
        return this.client.dropNamespace(namespace);
    }

    public boolean setProperties(org.apache.iceberg.catalog.Namespace namespace, Map<String, String> properties) {
        return this.client.setProperties(namespace, properties);
    }

    public boolean removeProperties(org.apache.iceberg.catalog.Namespace namespace, Set<String> properties) {
        return this.client.removeProperties(namespace, properties);
    }

    public void setConf(Object conf) {
        this.config = conf;
    }

    @VisibleForTesting
    String currentHash() {
        return this.client.getRef().getHash();
    }

    @VisibleForTesting
    String currentRefName() {
        return this.client.getRef().getName();
    }

    @VisibleForTesting
    FileIO fileIO() {
        return this.fileIO;
    }

    private TableReference parseTableReference(TableIdentifier tableIdentifier) {
        TableReference tr = TableReference.parse((String)tableIdentifier.name());
        Preconditions.checkArgument((!tr.hasTimestamp() ? 1 : 0) != 0, (Object)"Invalid table name: # is only allowed for hashes (reference by timestamp is not supported)");
        return tr;
    }

    private TableIdentifier identifierWithoutTableReference(TableIdentifier identifier, TableReference tableReference) {
        if (tableReference.hasReference()) {
            return TableIdentifier.of((org.apache.iceberg.catalog.Namespace)identifier.namespace(), (String)tableReference.getName());
        }
        return identifier;
    }

    protected Map<String, String> properties() {
        return this.catalogOptions;
    }

    protected ViewOperations newViewOps(TableIdentifier identifier) {
        TableReference tr = this.parseTableReference(identifier);
        return new NessieViewOperations(ContentKey.of((Namespace)Namespace.of((String[])identifier.namespace().levels()), (String)tr.getName()), this.client.withReference(tr.getReference(), tr.getHash()), this.fileIO);
    }

    public List<TableIdentifier> listViews(org.apache.iceberg.catalog.Namespace namespace) {
        return this.client.listViews(namespace);
    }

    public boolean dropView(TableIdentifier identifier) {
        TableReference tableReference = this.parseTableReference(identifier);
        return this.client.withReference(tableReference.getReference(), tableReference.getHash()).dropView(this.identifierWithoutTableReference(identifier, tableReference), false);
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        TableReference fromTableReference = this.parseTableReference(from);
        TableReference toTableReference = this.parseTableReference(to);
        this.validateReferenceForRename(fromTableReference, toTableReference, Content.Type.ICEBERG_VIEW);
        TableIdentifier fromIdentifier = NessieUtil.removeCatalogName(this.identifierWithoutTableReference(from, fromTableReference), this.name());
        TableIdentifier toIdentifier = NessieUtil.removeCatalogName(this.identifierWithoutTableReference(to, toTableReference), this.name());
        this.client.withReference(fromTableReference.getReference(), fromTableReference.getHash()).renameView(fromIdentifier, toIdentifier);
    }

    private void validateReferenceForRename(TableReference fromTableReference, TableReference toTableReference, Content.Type type) {
        String fromReference = fromTableReference.hasReference() ? fromTableReference.getReference() : this.client.getRef().getName();
        String toReference = toTableReference.hasReference() ? toTableReference.getReference() : this.client.getRef().getName();
        Preconditions.checkArgument((boolean)fromReference.equalsIgnoreCase(toReference), (String)"Cannot rename %s '%s' on reference '%s' to '%s' on reference '%s': source and target references must be the same.", (Object[])new Object[]{NessieUtil.contentTypeString(type).toLowerCase(Locale.ENGLISH), fromTableReference.getName(), fromReference, toTableReference.getName(), toReference});
    }
}

