/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.view.BaseViewOperations;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieViewOperations
extends BaseViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieViewOperations.class);
    private final NessieIcebergClient client;
    private final ContentKey key;
    private final FileIO fileIO;
    private IcebergView icebergView;

    NessieViewOperations(ContentKey key, NessieIcebergClient client, FileIO fileIO) {
        this.key = key;
        this.client = client;
        this.fileIO = fileIO;
    }

    public void doRefresh() {
        Reference reference;
        String metadataLocation;
        block7: {
            try {
                this.client.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException(String.format("Failed to refresh as ref '%s' is no longer valid.", this.client.getRef().getName()), e);
            }
            metadataLocation = null;
            reference = this.client.getRef().getReference();
            try {
                Content content = (Content)((GetContentBuilder)this.client.getApi().getContent().key(this.key).reference(reference)).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, reference, content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchViewException("View does not exist: %s in %s", new Object[]{this.key, reference});
                    }
                } else {
                    this.icebergView = (IcebergView)content.unwrap(IcebergView.class).orElseThrow(() -> new NessieContentNotFoundException(this.key, reference.getName()));
                    metadataLocation = this.icebergView.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchViewException("View does not exist: %s in %s", new Object[]{this.key, reference});
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, null, 2, location -> NessieUtil.loadViewMetadata(ViewMetadataParser.read((InputFile)this.io().newInputFile(location)), location, reference));
    }

    public void doCommit(ViewMetadata base, ViewMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadataIfRequired(metadata);
        boolean failure = false;
        try {
            String contentId = this.icebergView == null ? null : this.icebergView.getId();
            this.client.commitView(base, metadata, newMetadataLocation, contentId, this.key);
        }
        catch (HttpClientException | NessieConflictException | NessieNotFoundException ex) {
            if (ex instanceof NessieConflictException || ex instanceof NessieNotFoundException) {
                failure = true;
            }
            NessieUtil.handleExceptionsForCommits((Exception)ex, this.client.refName(), Content.Type.ICEBERG_VIEW).ifPresent(exception -> {
                throw exception;
            });
        }
        catch (NessieBadRequestException ex) {
            failure = true;
            throw NessieUtil.handleBadRequestForCommit(this.client, this.key, Content.Type.ICEBERG_VIEW).orElse((RuntimeException)((Object)ex));
        }
        finally {
            if (failure) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    protected String viewName() {
        return this.key.toString();
    }

    public FileIO io() {
        return this.fileIO;
    }
}

