/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import org.apache.iceberg.rest.RESTCatalogAdapter;
import org.apache.iceberg.rest.RESTCatalogServer;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.util.PropertyUtil;

class RESTServerCatalogAdapter
extends RESTCatalogAdapter {
    private static final String INCLUDE_CREDENTIALS = "include-credentials";
    private final RESTCatalogServer.CatalogContext catalogContext;

    RESTServerCatalogAdapter(RESTCatalogServer.CatalogContext catalogContext) {
        super(catalogContext.catalog());
        this.catalogContext = catalogContext;
    }

    public <T extends RESTResponse> T handleRequest(RESTCatalogAdapter.Route route, Map<String, String> vars, Object body, Class<T> responseType) {
        RESTResponse restResponse = super.handleRequest(route, vars, body, responseType);
        if (restResponse instanceof LoadTableResponse && PropertyUtil.propertyAsBoolean(this.catalogContext.configuration(), (String)INCLUDE_CREDENTIALS, (boolean)false)) {
            this.applyCredentials(this.catalogContext.configuration(), ((LoadTableResponse)restResponse).config());
        }
        return (T)restResponse;
    }

    private void applyCredentials(Map<String, String> catalogConfig, Map<String, String> tableConfig) {
        if (catalogConfig.containsKey("s3.access-key-id")) {
            tableConfig.put("s3.access-key-id", catalogConfig.get("s3.access-key-id"));
        }
        if (catalogConfig.containsKey("s3.secret-access-key")) {
            tableConfig.put("s3.secret-access-key", catalogConfig.get("s3.secret-access-key"));
        }
        if (catalogConfig.containsKey("s3.session-token")) {
            tableConfig.put("s3.session-token", catalogConfig.get("s3.session-token"));
        }
        if (catalogConfig.containsKey("gcs.oauth2.token")) {
            tableConfig.put("gcs.oauth2.token", catalogConfig.get("gcs.oauth2.token"));
        }
        catalogConfig.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("adls.sas-token.") || ((String)entry.getKey()).startsWith("adls.connection-string.")).forEach(entry -> tableConfig.put((String)entry.getKey(), (String)entry.getValue()));
    }
}

