/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcMetrics;
import org.apache.iceberg.orc.OrcRowWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

class OrcFileAppender<D>
implements FileAppender<D> {
    private final int batchSize;
    private final OutputFile file;
    private final Writer writer;
    private final VectorizedRowBatch batch;
    private final OrcRowWriter<D> valueWriter;
    private boolean isClosed = false;
    private final Configuration conf;
    private final MetricsConfig metricsConfig;

    OrcFileAppender(Schema schema, OutputFile file, BiFunction<Schema, TypeDescription, OrcRowWriter<?>> createWriterFunc, Configuration conf, Map<String, byte[]> metadata, int batchSize, MetricsConfig metricsConfig) {
        this.conf = conf;
        this.file = file;
        this.batchSize = batchSize;
        this.metricsConfig = metricsConfig;
        TypeDescription orcSchema = ORCSchemaUtil.convert(schema);
        this.batch = orcSchema.createRowBatch(this.batchSize);
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf).useUTCTimestamp(true);
        if (file instanceof HadoopOutputFile) {
            options.fileSystem(((HadoopOutputFile)file).getFileSystem());
        }
        options.setSchema(orcSchema);
        this.writer = OrcFileAppender.newOrcWriter(file, options, metadata);
        this.valueWriter = OrcFileAppender.newOrcRowWriter(schema, orcSchema, createWriterFunc);
    }

    public void add(D datum) {
        try {
            this.valueWriter.write(datum, this.batch);
            if (this.batch.size == this.batchSize) {
                this.writer.addRowBatch(this.batch);
                this.batch.reset();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Problem writing to ORC file %s", new Object[]{this.file.location()});
        }
    }

    public Metrics metrics() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"Cannot return metrics while appending to an open file.");
        return OrcMetrics.fromWriter(this.writer, this.valueWriter.metrics(), this.metricsConfig);
    }

    public long length() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"Cannot return length while appending to an open file.");
        return this.file.toInputFile().getLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Long> splitOffsets() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"File is not yet closed");
        try (Reader reader = ORC.newFileReader(this.file.toInputFile(), this.conf);){
            List stripes = reader.getStripes();
            List<Long> list = Collections.unmodifiableList(Lists.transform((List)stripes, StripeInformation::getOffset));
            return list;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Can't close ORC reader %s", new Object[]{this.file.location()});
        }
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            try {
                if (this.batch.size > 0) {
                    this.writer.addRowBatch(this.batch);
                    this.batch.reset();
                }
            }
            finally {
                this.writer.close();
                this.isClosed = true;
            }
        }
    }

    private static Writer newOrcWriter(OutputFile file, OrcFile.WriterOptions options, Map<String, byte[]> metadata) {
        Writer writer;
        Path locPath = new Path(file.location());
        try {
            writer = OrcFile.createWriter((Path)locPath, (OrcFile.WriterOptions)options);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Can't create file %s", new Object[]{locPath});
        }
        metadata.forEach((key, value) -> writer.addUserMetadata(key, ByteBuffer.wrap(value)));
        return writer;
    }

    private static <D> OrcRowWriter<D> newOrcRowWriter(Schema schema, TypeDescription orcSchema, BiFunction<Schema, TypeDescription, OrcRowWriter<?>> createWriterFunc) {
        return createWriterFunc.apply(schema, orcSchema);
    }
}

