/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.ExpressionToSearchArgument;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcBatchReader;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.orc.VectorizedRowBatchIterator;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;

class OrcIterable<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final Configuration config;
    private final Schema schema;
    private final InputFile file;
    private final Long start;
    private final Long length;
    private final Function<TypeDescription, OrcRowReader<?>> readerFunction;
    private final Expression filter;
    private final boolean caseSensitive;
    private final Function<TypeDescription, OrcBatchReader<?>> batchReaderFunction;
    private final int recordsPerBatch;
    private NameMapping nameMapping;

    OrcIterable(InputFile file, Configuration config, Schema schema, NameMapping nameMapping, Long start, Long length, Function<TypeDescription, OrcRowReader<?>> readerFunction, boolean caseSensitive, Expression filter, Function<TypeDescription, OrcBatchReader<?>> batchReaderFunction, int recordsPerBatch) {
        this.schema = schema;
        this.readerFunction = readerFunction;
        this.file = file;
        this.nameMapping = nameMapping;
        this.start = start;
        this.length = length;
        this.config = config;
        this.caseSensitive = caseSensitive;
        this.filter = filter == Expressions.alwaysTrue() ? null : filter;
        this.batchReaderFunction = batchReaderFunction;
        this.recordsPerBatch = recordsPerBatch;
    }

    public CloseableIterator<T> iterator() {
        TypeDescription readOrcSchema;
        Reader orcFileReader = ORC.newFileReader(this.file, this.config);
        this.addCloseable((Closeable)orcFileReader);
        TypeDescription fileSchema = orcFileReader.getSchema();
        if (ORCSchemaUtil.hasIds(fileSchema)) {
            readOrcSchema = ORCSchemaUtil.buildOrcProjection(this.schema, fileSchema);
        } else {
            if (this.nameMapping == null) {
                this.nameMapping = MappingUtil.create((Schema)this.schema);
            }
            TypeDescription typeWithIds = ORCSchemaUtil.applyNameMapping(fileSchema, this.nameMapping);
            readOrcSchema = ORCSchemaUtil.buildOrcProjection(this.schema, typeWithIds);
        }
        SearchArgument sarg = null;
        if (this.filter != null) {
            Expression boundFilter = Binder.bind((Types.StructType)this.schema.asStruct(), (Expression)this.filter, (boolean)this.caseSensitive);
            sarg = ExpressionToSearchArgument.convert(boundFilter, readOrcSchema);
        }
        VectorizedRowBatchIterator rowBatchIterator = OrcIterable.newOrcIterator(this.file, readOrcSchema, this.start, this.length, orcFileReader, sarg, this.recordsPerBatch);
        if (this.batchReaderFunction != null) {
            OrcBatchReader<?> batchReader = this.batchReaderFunction.apply(readOrcSchema);
            return CloseableIterator.transform((CloseableIterator)rowBatchIterator, pair -> {
                batchReader.setBatchContext((Long)pair.second());
                return batchReader.read((VectorizedRowBatch)pair.first());
            });
        }
        return new OrcRowIterator(rowBatchIterator, this.readerFunction.apply(readOrcSchema));
    }

    private static VectorizedRowBatchIterator newOrcIterator(InputFile file, TypeDescription readerSchema, Long start, Long length, Reader orcFileReader, SearchArgument sarg, int recordsPerBatch) {
        Reader.Options options = orcFileReader.options();
        if (start != null) {
            options.range(start.longValue(), length.longValue());
        }
        options.schema(readerSchema);
        options.searchArgument(sarg, new String[0]);
        try {
            return new VectorizedRowBatchIterator(file.location(), readerSchema, orcFileReader.rows(options), recordsPerBatch);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to get ORC rows for file: %s", new Object[]{file.location()});
        }
    }

    private static class OrcRowIterator<T>
    implements CloseableIterator<T> {
        private int nextRow;
        private VectorizedRowBatch current;
        private int currentBatchSize;
        private final VectorizedRowBatchIterator batchIter;
        private final OrcRowReader<T> reader;

        OrcRowIterator(VectorizedRowBatchIterator batchIter, OrcRowReader<T> reader) {
            this.batchIter = batchIter;
            this.reader = reader;
            this.current = null;
            this.nextRow = 0;
            this.currentBatchSize = 0;
        }

        public boolean hasNext() {
            return this.current != null && this.nextRow < this.currentBatchSize || this.batchIter.hasNext();
        }

        public T next() {
            if (this.current == null || this.nextRow >= this.currentBatchSize) {
                Pair<VectorizedRowBatch, Long> nextBatch = this.batchIter.next();
                this.current = (VectorizedRowBatch)nextBatch.first();
                this.currentBatchSize = this.current.size;
                this.nextRow = 0;
                this.reader.setBatchContext((Long)nextBatch.second());
            }
            int rowId = this.current.isSelectedInUse() ? this.current.selected[this.nextRow] : this.nextRow;
            ++this.nextRow;
            return this.reader.read(this.current, rowId);
        }

        public void close() throws IOException {
            this.batchIter.close();
        }
    }
}

