/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.util.List;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcWriters;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcRowWriter;
import org.apache.iceberg.orc.OrcSchemaWithTypeVisitor;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class GenericOrcWriter
implements OrcRowWriter<Record> {
    private final RecordWriter writer;

    private GenericOrcWriter(Schema expectedSchema, TypeDescription orcSchema) {
        Preconditions.checkArgument((orcSchema.getCategory() == TypeDescription.Category.STRUCT ? 1 : 0) != 0, (Object)("Top level must be a struct " + String.valueOf(orcSchema)));
        this.writer = (RecordWriter)OrcSchemaWithTypeVisitor.visit(expectedSchema, orcSchema, new WriteBuilder());
    }

    public static OrcRowWriter<Record> buildWriter(Schema expectedSchema, TypeDescription fileSchema) {
        return new GenericOrcWriter(expectedSchema, fileSchema);
    }

    @Override
    public void write(Record value, VectorizedRowBatch output) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value must not be null");
        this.writer.writeRow(value, output);
    }

    @Override
    public List<OrcValueWriter<?>> writers() {
        return this.writer.writers();
    }

    @Override
    public Stream<FieldMetrics<?>> metrics() {
        return this.writer.metrics();
    }

    private static class RecordWriter
    extends GenericOrcWriters.StructWriter<Record> {
        RecordWriter(Types.StructType struct, List<OrcValueWriter<?>> writers) {
            super(struct, writers);
        }

        @Override
        protected Object get(Record struct, int index) {
            return struct.get(index);
        }
    }

    private static class WriteBuilder
    extends OrcSchemaWithTypeVisitor<OrcValueWriter<?>> {
        private WriteBuilder() {
        }

        @Override
        public OrcValueWriter<Record> record(Types.StructType iStruct, TypeDescription record, List<String> names, List<OrcValueWriter<?>> fields) {
            return new RecordWriter(iStruct, fields);
        }

        @Override
        public OrcValueWriter<?> list(Types.ListType iList, TypeDescription array, OrcValueWriter<?> element) {
            return GenericOrcWriters.list(element);
        }

        @Override
        public OrcValueWriter<?> map(Types.MapType iMap, TypeDescription map, OrcValueWriter<?> key, OrcValueWriter<?> value) {
            return GenericOrcWriters.map(key, value);
        }

        @Override
        public OrcValueWriter<?> variant(Types.VariantType iVariant, TypeDescription variant, OrcValueWriter<?> metadata, OrcValueWriter<?> value) {
            return GenericOrcWriters.variants();
        }

        @Override
        public OrcValueWriter<?> primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
            if (null == iPrimitive) {
                return null;
            }
            switch (iPrimitive.typeId()) {
                case BOOLEAN: {
                    return GenericOrcWriters.booleans();
                }
                case INTEGER: {
                    return GenericOrcWriters.ints();
                }
                case LONG: {
                    return GenericOrcWriters.longs();
                }
                case FLOAT: {
                    return GenericOrcWriters.floats(ORCSchemaUtil.fieldId(primitive));
                }
                case DOUBLE: {
                    return GenericOrcWriters.doubles(ORCSchemaUtil.fieldId(primitive));
                }
                case DATE: {
                    return GenericOrcWriters.dates();
                }
                case TIME: {
                    return GenericOrcWriters.times();
                }
                case TIMESTAMP: {
                    Types.TimestampType timestampType = (Types.TimestampType)iPrimitive;
                    if (timestampType.shouldAdjustToUTC()) {
                        return GenericOrcWriters.timestampTz();
                    }
                    return GenericOrcWriters.timestamp();
                }
                case TIMESTAMP_NANO: {
                    Types.TimestampNanoType timestampNanoType = (Types.TimestampNanoType)iPrimitive;
                    if (timestampNanoType.shouldAdjustToUTC()) {
                        return GenericOrcWriters.timestampTzNanos();
                    }
                    return GenericOrcWriters.timestampNanos();
                }
                case STRING: {
                    return GenericOrcWriters.strings();
                }
                case UUID: {
                    return GenericOrcWriters.uuids();
                }
                case FIXED: {
                    return GenericOrcWriters.byteArrays();
                }
                case BINARY: {
                    return GenericOrcWriters.byteBuffers();
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)iPrimitive;
                    return GenericOrcWriters.decimal(decimalType.precision(), decimalType.scale());
                }
            }
            throw new IllegalArgumentException(String.format("Invalid iceberg type %s corresponding to ORC type %s", iPrimitive, primitive));
        }
    }
}

