/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetAvroValueReaders {
    private ParquetAvroValueReaders() {
    }

    public static ParquetValueReader<GenericData.Record> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return (ParquetValueReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, new ReadBuilder(expectedSchema, fileSchema));
    }

    static class RecordReader
    extends ParquetValueReaders.StructReader<GenericData.Record, GenericData.Record> {
        private final org.apache.avro.Schema schema;

        RecordReader(List<org.apache.parquet.schema.Type> types, List<ParquetValueReader<?>> readers, org.apache.avro.Schema schema) {
            super(types, readers);
            this.schema = schema;
        }

        @Override
        protected GenericData.Record newStructData(GenericData.Record reuse) {
            if (reuse != null) {
                return reuse;
            }
            return new GenericData.Record(this.schema);
        }

        @Override
        protected Object getField(GenericData.Record intermediate, int pos) {
            return intermediate.get(pos);
        }

        @Override
        protected GenericData.Record buildStruct(GenericData.Record struct) {
            return struct;
        }

        @Override
        protected void set(GenericData.Record struct, int pos, Object value) {
            struct.put(pos, value);
        }
    }

    public static class TimestampMillisReader
    extends ParquetValueReaders.UnboxedReader<Long> {
        TimestampMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public long readLong() {
            return 1000L * this.column.nextLong();
        }
    }

    public static class TimeMillisReader
    extends ParquetValueReaders.UnboxedReader<Long> {
        TimeMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public long readLong() {
            return 1000L * this.column.nextLong();
        }
    }

    static class FixedReader
    extends ParquetValueReaders.PrimitiveReader<GenericData.Fixed> {
        private final org.apache.avro.Schema schema;

        FixedReader(ColumnDescriptor desc, org.apache.avro.Schema schema) {
            super(desc);
            this.schema = schema;
        }

        @Override
        public GenericData.Fixed read(GenericData.Fixed reuse) {
            GenericData.Fixed fixed = reuse != null ? reuse : new GenericData.Fixed(this.schema);
            this.column.nextBinary().toByteBuffer().get(fixed.bytes());
            return fixed;
        }
    }

    static class UUIDReader
    extends ParquetValueReaders.PrimitiveReader<UUID> {
        UUIDReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public UUID read(UUID ignored) {
            return UUIDUtil.convert((ByteBuffer)this.column.nextBinary().toByteBuffer());
        }
    }

    static class Utf8Reader
    extends ParquetValueReaders.PrimitiveReader<Utf8> {
        Utf8Reader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public Utf8 read(Utf8 reuse) {
            Utf8 utf8 = reuse != null ? reuse : new Utf8();
            ByteBuffer buffer = this.column.nextBinary().toByteBuffer();
            utf8.setByteLength(buffer.remaining());
            buffer.get(utf8.getBytes(), 0, buffer.remaining());
            return utf8;
        }
    }

    static class StringReader
    extends ParquetValueReaders.PrimitiveReader<String> {
        StringReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public String read(String ignored) {
            return this.column.nextBinary().toStringUsingUTF8();
        }
    }

    static class DecimalReader
    extends ParquetValueReaders.PrimitiveReader<BigDecimal> {
        private final int scale;

        DecimalReader(ColumnDescriptor desc, int scale) {
            super(desc);
            this.scale = scale;
        }

        @Override
        public BigDecimal read(BigDecimal ignored) {
            return new BigDecimal(new BigInteger(this.column.nextBinary().getBytesUnsafe()), this.scale);
        }
    }

    private static class ReadBuilder
    extends TypeWithSchemaVisitor<ParquetValueReader<?>> {
        private final Schema schema;
        private final Map<Type, org.apache.avro.Schema> avroSchemas;
        private final MessageType type;

        ReadBuilder(Schema schema, MessageType type) {
            this.schema = schema;
            this.avroSchemas = AvroSchemaUtil.convertTypes((Types.StructType)schema.asStruct(), (String)type.getName());
            this.type = type;
        }

        @Override
        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return this.struct(expected, message.asGroupType(), (List)fieldReaders);
        }

        @Override
        public ParquetValueReader<?> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            org.apache.avro.Schema avroSchema = this.avroSchemas.get(expected);
            HashMap readersById = Maps.newHashMap();
            HashMap typesById = Maps.newHashMap();
            List fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                org.apache.parquet.schema.Type fieldType = (org.apache.parquet.schema.Type)fields.get(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                int id = fieldType.getId().intValue();
                readersById.put(id, ParquetValueReaders.option(fieldType, fieldD, fieldReaders.get(i)));
                typesById.put(id, fieldType);
            }
            List expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList reorderedFields = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            ArrayList types = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            Iterator iterator = expectedFields.iterator();
            while (iterator.hasNext()) {
                Types.NestedField field = (Types.NestedField)iterator.next();
                int id = field.fieldId();
                ParquetValueReader reader = (ParquetValueReader)readersById.get(id);
                if (reader != null) {
                    reorderedFields.add(reader);
                    types.add((org.apache.parquet.schema.Type)typesById.get(id));
                    continue;
                }
                reorderedFields.add(ParquetValueReaders.nulls());
                types.add(null);
            }
            return new RecordReader(types, reorderedFields, avroSchema);
        }

        @Override
        public ParquetValueReader<?> list(Types.ListType expectedList, GroupType array, ParquetValueReader<?> elementReader) {
            GroupType repeated = ((org.apache.parquet.schema.Type)array.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName())) - 1;
            return new ParquetValueReaders.ListReader(repeatedD, repeatedR, ParquetValueReaders.option(elementType, elementD, elementReader));
        }

        @Override
        public ParquetValueReader<?> map(Types.MapType expectedMap, GroupType map, ParquetValueReader<?> keyReader, ParquetValueReader<?> valueReader) {
            GroupType repeatedKeyValue = ((org.apache.parquet.schema.Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName())) - 1;
            org.apache.parquet.schema.Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName())) - 1;
            return new ParquetValueReaders.MapReader(repeatedD, repeatedR, ParquetValueReaders.option(keyType, keyD, keyReader), ParquetValueReaders.option(valueType, valueD, valueReader));
        }

        @Override
        public ParquetValueReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            boolean isMapKey = this.fieldNames.contains("key");
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        if (isMapKey) {
                            return new StringReader(desc);
                        }
                        return new Utf8Reader(desc);
                    }
                    case DATE: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: 
                    case INT_64: 
                    case TIME_MICROS: 
                    case TIMESTAMP_MICROS: {
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case TIME_MILLIS: {
                        return new TimeMillisReader(desc);
                    }
                    case TIMESTAMP_MILLIS: {
                        return new TimestampMillisReader(desc);
                    }
                    case DECIMAL: {
                        DecimalMetadata decimal = primitive.getDecimalMetadata();
                        switch (primitive.getPrimitiveTypeName()) {
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return new DecimalReader(desc, decimal.getScale());
                            }
                            case INT64: {
                                return new ParquetValueReaders.IntegerAsDecimalReader(desc, decimal.getScale());
                            }
                            case INT32: {
                                return new ParquetValueReaders.LongAsDecimalReader(desc, decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + primitive.getPrimitiveTypeName());
                    }
                    case BSON: {
                        return new ParquetValueReaders.BytesReader(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + primitive.getOriginalType());
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    int fieldId = primitive.getId().intValue();
                    org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)this.schema.findType(fieldId));
                    return new FixedReader(desc, avroSchema);
                }
                case BINARY: {
                    return new ParquetValueReaders.BytesReader(desc);
                }
                case INT32: {
                    if (expected != null && expected.typeId() == Type.TypeID.LONG) {
                        return new ParquetValueReaders.IntAsLongReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case FLOAT: {
                    if (expected != null && expected.typeId() == Type.TypeID.DOUBLE) {
                        return new ParquetValueReaders.FloatAsDoubleReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT64: 
                case BOOLEAN: 
                case DOUBLE: {
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }
    }
}

