/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ApplyNameMapping;
import org.apache.iceberg.parquet.MessageTypeToType;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.PruneColumns;
import org.apache.iceberg.parquet.TypeToMessageType;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetSchemaUtil {
    private ParquetSchemaUtil() {
    }

    public static MessageType convert(Schema schema, String name) {
        return new TypeToMessageType().convert(schema, name);
    }

    public static Schema convert(MessageType parquetSchema) {
        MessageTypeToType converter = new MessageTypeToType((GroupType)parquetSchema);
        return new Schema(ParquetTypeVisitor.visit((Type)parquetSchema, converter).asNestedType().fields(), converter.getAliases());
    }

    public static MessageType pruneColumns(MessageType fileSchema, Schema expectedSchema) {
        Set selectedIds = TypeUtil.getProjectedIds((Schema)expectedSchema);
        return (MessageType)ParquetTypeVisitor.visit((Type)fileSchema, new PruneColumns(selectedIds));
    }

    public static MessageType pruneColumnsFallback(MessageType fileSchema, Schema expectedSchema) {
        HashSet selectedIds = Sets.newHashSet();
        for (Types.NestedField field : expectedSchema.columns()) {
            selectedIds.add(field.fieldId());
        }
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (Type type : fileSchema.getFields()) {
            if (selectedIds.contains(ordinal)) {
                builder.addField(type.withId(ordinal));
            }
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static boolean hasIds(MessageType fileSchema) {
        return ParquetTypeVisitor.visit((Type)fileSchema, new HasIds());
    }

    public static MessageType addFallbackIds(MessageType fileSchema) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (Type type : fileSchema.getFields()) {
            builder.addField(type.withId(ordinal));
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static MessageType applyNameMapping(MessageType fileSchema, NameMapping nameMapping) {
        return (MessageType)ParquetTypeVisitor.visit((Type)fileSchema, new ApplyNameMapping(nameMapping));
    }

    public static class HasIds
    extends ParquetTypeVisitor<Boolean> {
        @Override
        public Boolean message(MessageType message, List<Boolean> fields) {
            return this.struct((GroupType)message, (List)fields);
        }

        @Override
        public Boolean struct(GroupType struct, List<Boolean> hasIds) {
            for (Boolean hasId : hasIds) {
                if (!hasId.booleanValue()) continue;
                return true;
            }
            return struct.getId() != null;
        }

        @Override
        public Boolean list(GroupType array, Boolean hasId) {
            return hasId != false || array.getId() != null;
        }

        @Override
        public Boolean map(GroupType map, Boolean keyHasId, Boolean valueHasId) {
            return keyHasId != false || valueHasId != false || map.getId() != null;
        }

        @Override
        public Boolean primitive(PrimitiveType primitive) {
            return primitive.getId() != null;
        }
    }
}

