/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TypeWithSchemaVisitor<T> {
    protected LinkedList<String> fieldNames = Lists.newLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(Type iType, org.apache.parquet.schema.Type type, TypeWithSchemaVisitor<T> visitor) {
        if (type instanceof MessageType) {
            Types.StructType struct = iType != null ? iType.asStructType() : null;
            return visitor.message(struct, (MessageType)type, TypeWithSchemaVisitor.visitFields(struct, type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            Type.PrimitiveType iPrimitive = iType != null ? iType.asPrimitiveType() : null;
            return visitor.primitive(iPrimitive, type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        OriginalType annotation = group.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case LIST: {
                    Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid list: top-level group is repeated: %s", (Object)group);
                    Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid list: does not contain single repeated field: %s", (Object)group);
                    GroupType repeatedElement = ((org.apache.parquet.schema.Type)group.getFields().get(0)).asGroupType();
                    Preconditions.checkArgument((boolean)repeatedElement.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid list: inner group is not repeated");
                    Preconditions.checkArgument((repeatedElement.getFieldCount() <= 1 ? 1 : 0) != 0, (String)"Invalid list: repeated group is not a single field: %s", (Object)group);
                    Types.ListType list = null;
                    Types.NestedField element = null;
                    if (iType != null) {
                        list = iType.asListType();
                        element = (Types.NestedField)list.fields().get(0);
                    }
                    visitor.fieldNames.push(repeatedElement.getName());
                    try {
                        T elementResult = null;
                        if (repeatedElement.getFieldCount() > 0) {
                            elementResult = TypeWithSchemaVisitor.visitField(element, repeatedElement.getType(0), visitor);
                        }
                        T t = visitor.list(list, group, elementResult);
                        return t;
                    }
                    finally {
                        visitor.fieldNames.pop();
                    }
                }
                case MAP: {
                    Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid map: top-level group is repeated: %s", (Object)group);
                    Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid map: does not contain single repeated field: %s", (Object)group);
                    GroupType repeatedKeyValue = group.getType(0).asGroupType();
                    Preconditions.checkArgument((boolean)repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid map: inner group is not repeated");
                    Preconditions.checkArgument((repeatedKeyValue.getFieldCount() <= 2 ? 1 : 0) != 0, (Object)"Invalid map: repeated group does not have 2 fields");
                    Types.MapType map = null;
                    Types.NestedField keyField = null;
                    Types.NestedField valueField = null;
                    if (iType != null) {
                        map = iType.asMapType();
                        keyField = (Types.NestedField)map.fields().get(0);
                        valueField = (Types.NestedField)map.fields().get(1);
                    }
                    visitor.fieldNames.push(repeatedKeyValue.getName());
                    try {
                        T keyResult = null;
                        T valueResult = null;
                        switch (repeatedKeyValue.getFieldCount()) {
                            case 2: {
                                keyResult = TypeWithSchemaVisitor.visitField(keyField, repeatedKeyValue.getType(0), visitor);
                                valueResult = TypeWithSchemaVisitor.visitField(valueField, repeatedKeyValue.getType(1), visitor);
                                break;
                            }
                            case 1: {
                                org.apache.parquet.schema.Type keyOrValue = repeatedKeyValue.getType(0);
                                if (keyOrValue.getName().equalsIgnoreCase("key")) {
                                    keyResult = TypeWithSchemaVisitor.visitField(keyField, keyOrValue, visitor);
                                    break;
                                }
                                valueResult = TypeWithSchemaVisitor.visitField(valueField, keyOrValue, visitor);
                                break;
                            }
                        }
                        T t = visitor.map(map, group, keyResult, valueResult);
                        return t;
                    }
                    finally {
                        visitor.fieldNames.pop();
                    }
                }
            }
        }
        Types.StructType struct = iType != null ? iType.asStructType() : null;
        return visitor.struct(struct, group, TypeWithSchemaVisitor.visitFields(struct, group, visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitField(Types.NestedField iField, org.apache.parquet.schema.Type field, TypeWithSchemaVisitor<T> visitor) {
        visitor.fieldNames.push(field.getName());
        try {
            T t = TypeWithSchemaVisitor.visit(iField != null ? iField.type() : null, field, visitor);
            return t;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> List<T> visitFields(Types.StructType struct, GroupType group, TypeWithSchemaVisitor<T> visitor) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)group.getFieldCount());
        for (org.apache.parquet.schema.Type field : group.getFields()) {
            int id = -1;
            if (field.getId() != null) {
                id = field.getId().intValue();
            }
            Types.NestedField iField = struct != null && id >= 0 ? struct.field(id) : null;
            results.add(TypeWithSchemaVisitor.visitField(iField, field, visitor));
        }
        return results;
    }

    public T message(Types.StructType iStruct, MessageType message, List<T> fields) {
        return null;
    }

    public T struct(Types.StructType iStruct, GroupType struct, List<T> fields) {
        return null;
    }

    public T list(Types.ListType iList, GroupType array, T element) {
        return null;
    }

    public T map(Types.MapType iMap, GroupType map, T key, T value) {
        return null;
    }

    public T primitive(Type.PrimitiveType iPrimitive, PrimitiveType primitive) {
        return null;
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

