/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.ParquetVariantReaders;
import org.apache.iceberg.parquet.ParquetVariantUtil;
import org.apache.iceberg.parquet.ParquetVariantVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class VariantReaderBuilder
extends ParquetVariantVisitor<ParquetValueReader<?>> {
    private final MessageType schema;
    private final Iterable<String> basePath;
    private final Deque<String> fieldNames = Lists.newLinkedList();

    public VariantReaderBuilder(MessageType schema, Iterable<String> basePath) {
        this.schema = schema;
        this.basePath = basePath;
    }

    @Override
    public void beforeField(Type type) {
        this.fieldNames.addLast(type.getName());
    }

    @Override
    public void afterField(Type type) {
        this.fieldNames.removeLast();
    }

    private String[] currentPath() {
        return (String[])Streams.concat((Stream[])new Stream[]{Streams.stream(this.basePath), this.fieldNames.stream()}).toArray(String[]::new);
    }

    private String[] path(String ... names) {
        return (String[])Streams.concat((Stream[])new Stream[]{Streams.stream(this.basePath), this.fieldNames.stream(), Stream.of(names)}).toArray(String[]::new);
    }

    @Override
    public ParquetValueReader<?> variant(GroupType variant, ParquetValueReader<?> metadataReader, ParquetValueReader<?> valueReader) {
        return ParquetVariantReaders.variant(metadataReader, valueReader);
    }

    @Override
    public ParquetValueReader<?> metadata(PrimitiveType metadata) {
        ColumnDescriptor desc = this.schema.getColumnDescription(this.currentPath());
        return ParquetVariantReaders.metadata(desc);
    }

    @Override
    public ParquetVariantReaders.VariantValueReader serialized(PrimitiveType value) {
        ColumnDescriptor desc = this.schema.getColumnDescription(this.currentPath());
        return ParquetVariantReaders.serialized(desc);
    }

    @Override
    public ParquetVariantReaders.VariantValueReader primitive(PrimitiveType primitive) {
        ColumnDescriptor desc = this.schema.getColumnDescription(this.currentPath());
        if (primitive.getLogicalTypeAnnotation() != null) {
            Optional reader = primitive.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeToVariantReader(desc));
            if (reader.isPresent()) {
                return (ParquetVariantReaders.VariantValueReader)reader.get();
            }
        } else {
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: {
                    return ParquetVariantReaders.asVariant(PhysicalType.BINARY, ParquetValueReaders.byteBuffers(desc));
                }
                case BOOLEAN: {
                    return ParquetVariantReaders.asVariant(PhysicalType.BOOLEAN_TRUE, ParquetValueReaders.unboxed(desc));
                }
                case INT32: {
                    return ParquetVariantReaders.asVariant(PhysicalType.INT32, ParquetValueReaders.unboxed(desc));
                }
                case INT64: {
                    return ParquetVariantReaders.asVariant(PhysicalType.INT64, ParquetValueReaders.unboxed(desc));
                }
                case FLOAT: {
                    return ParquetVariantReaders.asVariant(PhysicalType.FLOAT, ParquetValueReaders.unboxed(desc));
                }
                case DOUBLE: {
                    return ParquetVariantReaders.asVariant(PhysicalType.DOUBLE, ParquetValueReaders.unboxed(desc));
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported shredded value type: " + String.valueOf(primitive));
    }

    @Override
    public ParquetVariantReaders.VariantValueReader value(GroupType group, ParquetValueReader<?> valueReader, ParquetValueReader<?> typedReader) {
        int valueDL = valueReader != null ? this.schema.getMaxDefinitionLevel(this.path("value")) - 1 : Integer.MAX_VALUE;
        int typedDL = typedReader != null ? this.schema.getMaxDefinitionLevel(this.path("typed_value")) - 1 : Integer.MAX_VALUE;
        return ParquetVariantReaders.shredded(valueDL, valueReader, typedDL, typedReader);
    }

    @Override
    public ParquetVariantReaders.VariantValueReader object(GroupType group, ParquetValueReader<?> valueReader, List<ParquetValueReader<?>> fieldResults) {
        int valueDL = valueReader != null ? this.schema.getMaxDefinitionLevel(this.path("value")) - 1 : Integer.MAX_VALUE;
        int fieldsDL = this.schema.getMaxDefinitionLevel(this.path("typed_value")) - 1;
        List<String> shreddedFieldNames = group.getType("typed_value").asGroupType().getFields().stream().map(Type::getName).collect(Collectors.toList());
        List<ParquetVariantReaders.VariantValueReader> fieldReaders = fieldResults.stream().map(ParquetVariantReaders.VariantValueReader.class::cast).collect(Collectors.toList());
        return ParquetVariantReaders.objects(valueDL, valueReader, fieldsDL, shreddedFieldNames, fieldReaders);
    }

    @Override
    public ParquetVariantReaders.VariantValueReader array(GroupType array, ParquetValueReader<?> valueReader, ParquetValueReader<?> elementReader) {
        int valueDL = valueReader != null ? this.schema.getMaxDefinitionLevel(this.path("value")) - 1 : Integer.MAX_VALUE;
        int typedDL = this.schema.getMaxDefinitionLevel(this.path("typed_value")) - 1;
        int repeatedDL = this.schema.getMaxDefinitionLevel(this.path("typed_value", "list")) - 1;
        int repeatedRL = this.schema.getMaxRepetitionLevel(this.path("typed_value", "list")) - 1;
        ParquetVariantReaders.VariantValueReader typedReader = ParquetVariantReaders.array(repeatedDL, repeatedRL, elementReader);
        return ParquetVariantReaders.shredded(valueDL, valueReader, typedDL, typedReader);
    }

    private static class LogicalTypeToVariantReader
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetVariantReaders.VariantValueReader> {
        private final ColumnDescriptor desc;

        private LogicalTypeToVariantReader(ColumnDescriptor desc) {
            this.desc = desc;
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation ignored) {
            ParquetVariantReaders.VariantValueReader reader = ParquetVariantReaders.asVariant(PhysicalType.STRING, ParquetValueReaders.strings(this.desc));
            return Optional.of(reader);
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logical) {
            PhysicalType variantType = LogicalTypeToVariantReader.variantDecimalType(this.desc.getPrimitiveType());
            ParquetVariantReaders.VariantValueReader reader = ParquetVariantReaders.asVariant(variantType, ParquetValueReaders.bigDecimals(this.desc));
            return Optional.of(reader);
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation ignored) {
            ParquetVariantReaders.VariantValueReader reader = ParquetVariantReaders.asVariant(PhysicalType.DATE, ParquetValueReaders.unboxed(this.desc));
            return Optional.of(reader);
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logical) {
            ParquetVariantReaders.VariantValueReader reader = ParquetVariantReaders.asVariant(ParquetVariantUtil.convert(logical), ParquetValueReaders.timestamps(this.desc));
            return Optional.of(reader);
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation logical) {
            if (logical.getUnit() != LogicalTypeAnnotation.TimeUnit.MICROS || logical.isAdjustedToUTC()) {
                throw new UnsupportedOperationException("Unsupported shredded value type: " + String.valueOf(logical));
            }
            ParquetVariantReaders.VariantValueReader reader = ParquetVariantReaders.asVariant(PhysicalType.TIME, ParquetValueReaders.times(this.desc));
            return Optional.of(reader);
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation logical) {
            ParquetVariantReaders.VariantValueReader reader;
            if (!logical.isSigned()) {
                throw new UnsupportedOperationException("Unsupported shredded value type: " + String.valueOf(logical));
            }
            switch (logical.getBitWidth()) {
                case 64: {
                    reader = ParquetVariantReaders.asVariant(PhysicalType.INT64, ParquetValueReaders.unboxed(this.desc));
                    break;
                }
                case 32: {
                    reader = ParquetVariantReaders.asVariant(PhysicalType.INT32, ParquetValueReaders.unboxed(this.desc));
                    break;
                }
                case 16: {
                    reader = ParquetVariantReaders.asVariant(PhysicalType.INT16, ParquetValueReaders.intsAsShort(this.desc));
                    break;
                }
                case 8: {
                    reader = ParquetVariantReaders.asVariant(PhysicalType.INT8, ParquetValueReaders.intsAsByte(this.desc));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid bit width for int: " + logical.getBitWidth());
                }
            }
            return Optional.of(reader);
        }

        public Optional<ParquetVariantReaders.VariantValueReader> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation logical) {
            ParquetVariantReaders.VariantValueReader reader = ParquetVariantReaders.asVariant(PhysicalType.UUID, ParquetValueReaders.uuids(this.desc));
            return Optional.of(reader);
        }

        private static PhysicalType variantDecimalType(PrimitiveType primitive) {
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return PhysicalType.DECIMAL16;
                }
                case INT64: {
                    return PhysicalType.DECIMAL8;
                }
                case INT32: {
                    return PhysicalType.DECIMAL4;
                }
            }
            throw new IllegalArgumentException("Invalid primitive type for decimal: " + String.valueOf(primitive));
        }
    }
}

