/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DecimalUtil;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.hadoop.BloomFilterReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetBloomRowGroupFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetBloomRowGroupFilter.class);
    private final Schema schema;
    private final Expression expr;
    private final boolean caseSensitive;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    public ParquetBloomRowGroupFilter(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public ParquetBloomRowGroupFilter(Schema schema, Expression unbound, boolean caseSensitive) {
        this.schema = schema;
        Types.StructType struct = schema.asStruct();
        this.expr = Binder.bind((Types.StructType)struct, (Expression)Expressions.rewriteNot((Expression)unbound), (boolean)caseSensitive);
        this.caseSensitive = caseSensitive;
    }

    public boolean shouldRead(MessageType fileSchema, BlockMetaData rowGroup, BloomFilterReader bloomReader) {
        return new BloomEvalVisitor().eval(fileSchema, rowGroup, bloomReader);
    }

    private class BloomEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private BloomFilterReader bloomReader;
        private Set<Integer> fieldsWithBloomFilter = null;
        private Map<Integer, ColumnChunkMetaData> columnMetaMap = null;
        private Map<Integer, BloomFilter> bloomCache = null;
        private Map<Integer, PrimitiveType> parquetPrimitiveTypes = null;
        private Map<Integer, Type> types = null;

        private BloomEvalVisitor() {
        }

        private boolean eval(MessageType fileSchema, BlockMetaData rowGroup, BloomFilterReader bloomFilterReader) {
            this.bloomReader = bloomFilterReader;
            this.fieldsWithBloomFilter = Sets.newHashSet();
            this.columnMetaMap = Maps.newHashMap();
            this.bloomCache = Maps.newHashMap();
            this.parquetPrimitiveTypes = Maps.newHashMap();
            this.types = Maps.newHashMap();
            for (ColumnChunkMetaData meta : rowGroup.getColumns()) {
                PrimitiveType colType = fileSchema.getType(meta.getPath().toArray()).asPrimitiveType();
                if (colType.getId() == null) continue;
                int id = colType.getId().intValue();
                Type icebergType = ParquetBloomRowGroupFilter.this.schema.findType(id);
                if (!ParquetUtil.hasNoBloomFilterPages(meta)) {
                    this.fieldsWithBloomFilter.add(id);
                }
                this.columnMetaMap.put(id, meta);
                this.parquetPrimitiveTypes.put(id, colType);
                this.types.put(id, icebergType);
            }
            Set filterRefs = Binder.boundReferences((Types.StructType)ParquetBloomRowGroupFilter.this.schema.asStruct(), (List)ImmutableList.of((Object)ParquetBloomRowGroupFilter.this.expr), (boolean)ParquetBloomRowGroupFilter.this.caseSensitive);
            if (!filterRefs.isEmpty()) {
                Sets.SetView overlappedBloomFilters = Sets.intersection(this.fieldsWithBloomFilter, (Set)filterRefs);
                if (overlappedBloomFilters.isEmpty()) {
                    return true;
                }
                LOG.debug("Using Bloom filters for columns with IDs: {}", (Object)overlappedBloomFilters);
            }
            return ExpressionVisitors.visitEvaluator((Expression)ParquetBloomRowGroupFilter.this.expr, (ExpressionVisitors.ExpressionVisitor)this);
        }

        public Boolean alwaysTrue() {
            return true;
        }

        public Boolean alwaysFalse() {
            return false;
        }

        public Boolean not(Boolean result) {
            throw new UnsupportedOperationException("This path shouldn't be reached.");
        }

        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        public <T> Boolean isNull(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean notNull(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean isNaN(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean notNaN(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            if (!this.fieldsWithBloomFilter.contains(id)) {
                return true;
            }
            BloomFilter bloom = this.loadBloomFilter(id);
            Type type = this.types.get(id);
            Object value = lit.value();
            return this.shouldRead(this.parquetPrimitiveTypes.get(id), value, bloom, type);
        }

        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
            int id = ref.fieldId();
            if (!this.fieldsWithBloomFilter.contains(id)) {
                return true;
            }
            BloomFilter bloom = this.loadBloomFilter(id);
            Type type = this.types.get(id);
            for (T e : literalSet) {
                if (!this.shouldRead(this.parquetPrimitiveTypes.get(id), e, bloom, type)) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
            return true;
        }

        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        private BloomFilter loadBloomFilter(int id) {
            if (this.bloomCache.containsKey(id)) {
                return this.bloomCache.get(id);
            }
            ColumnChunkMetaData columnChunkMetaData = this.columnMetaMap.get(id);
            BloomFilter bloomFilter = this.bloomReader.readBloomFilter(columnChunkMetaData);
            if (bloomFilter == null) {
                throw new IllegalStateException("Failed to read required bloom filter for id: " + id);
            }
            this.bloomCache.put(id, bloomFilter);
            return bloomFilter;
        }

        private <T> boolean shouldRead(PrimitiveType primitiveType, T value, BloomFilter bloom, Type type) {
            long hashValue = 0L;
            switch (primitiveType.getPrimitiveTypeName()) {
                case INT32: {
                    switch (type.typeId()) {
                        case DECIMAL: {
                            BigDecimal decimalValue = (BigDecimal)value;
                            hashValue = bloom.hash(decimalValue.unscaledValue().intValue());
                            return bloom.findHash(hashValue);
                        }
                        case INTEGER: 
                        case DATE: {
                            hashValue = bloom.hash(((Number)value).intValue());
                            return bloom.findHash(hashValue);
                        }
                    }
                    return true;
                }
                case INT64: {
                    switch (type.typeId()) {
                        case DECIMAL: {
                            BigDecimal decimalValue = (BigDecimal)value;
                            hashValue = bloom.hash(decimalValue.unscaledValue().longValue());
                            return bloom.findHash(hashValue);
                        }
                        case LONG: 
                        case TIME: 
                        case TIMESTAMP: {
                            hashValue = bloom.hash(((Number)value).longValue());
                            return bloom.findHash(hashValue);
                        }
                    }
                    return true;
                }
                case FLOAT: {
                    hashValue = bloom.hash(((Number)value).floatValue());
                    return bloom.findHash(hashValue);
                }
                case DOUBLE: {
                    hashValue = bloom.hash(((Number)value).doubleValue());
                    return bloom.findHash(hashValue);
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    switch (type.typeId()) {
                        case STRING: {
                            hashValue = bloom.hash(Binary.fromCharSequence((CharSequence)((CharSequence)value)));
                            return bloom.findHash(hashValue);
                        }
                        case BINARY: 
                        case FIXED: {
                            hashValue = bloom.hash(Binary.fromConstantByteBuffer((ByteBuffer)((ByteBuffer)value)));
                            return bloom.findHash(hashValue);
                        }
                        case DECIMAL: {
                            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation metadata = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)primitiveType.getLogicalTypeAnnotation();
                            int scale = metadata.getScale();
                            int precision = metadata.getPrecision();
                            byte[] requiredBytes = new byte[TypeUtil.decimalRequiredBytes((int)precision)];
                            byte[] binary = DecimalUtil.toReusedFixLengthBytes((int)precision, (int)scale, (BigDecimal)((BigDecimal)value), (byte[])requiredBytes);
                            hashValue = bloom.hash(Binary.fromConstantByteArray((byte[])binary));
                            return bloom.findHash(hashValue);
                        }
                        case UUID: {
                            hashValue = bloom.hash(Binary.fromConstantByteArray((byte[])UUIDUtil.convert((UUID)((UUID)value))));
                            return bloom.findHash(hashValue);
                        }
                    }
                    return true;
                }
            }
            return true;
        }

        public <T> Boolean handleNonReference(Bound<T> term) {
            return true;
        }
    }
}

