/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.util.List;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.parquet.BaseParquetWriter;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.MessageType;

public class InternalWriter<T extends StructLike>
extends BaseParquetWriter<T> {
    private static final InternalWriter<?> INSTANCE = new InternalWriter();

    private InternalWriter() {
    }

    public static <T extends StructLike> ParquetValueWriter<T> create(MessageType type) {
        return INSTANCE.createWriter(type);
    }

    @Override
    protected ParquetValueWriters.StructWriter<T> createStructWriter(List<ParquetValueWriter<?>> writers) {
        return ParquetValueWriters.recordWriter(writers);
    }

    @Override
    protected ParquetValueWriter<?> fixedWriter(ColumnDescriptor desc) {
        return ParquetValueWriters.fixedBuffers(desc);
    }

    @Override
    protected ParquetValueWriter<?> dateWriter(ColumnDescriptor desc) {
        return ParquetValueWriters.ints(desc);
    }

    @Override
    protected ParquetValueWriter<?> timeWriter(ColumnDescriptor desc) {
        return ParquetValueWriters.longs(desc);
    }

    @Override
    protected ParquetValueWriter<?> timestampWriter(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        return ParquetValueWriters.longs(desc);
    }
}

