/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetMetrics;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetUtil {
    private static final long UNIX_EPOCH_JULIAN = 2440588L;

    private ParquetUtil() {
    }

    public static Metrics fileMetrics(InputFile file, MetricsConfig metricsConfig) {
        return ParquetUtil.fileMetrics(file, metricsConfig, null);
    }

    public static Metrics fileMetrics(InputFile file, MetricsConfig metricsConfig, NameMapping nameMapping) {
        Metrics metrics;
        block8: {
            ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file(file));
            try {
                metrics = ParquetUtil.footerMetrics(reader.getFooter(), Stream.empty(), metricsConfig, nameMapping);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to read footer of file: %s", new Object[]{file.location()});
                }
            }
            reader.close();
        }
        return metrics;
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig) {
        return ParquetUtil.footerMetrics(metadata, fieldMetrics, metricsConfig, null);
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig, NameMapping nameMapping) {
        Preconditions.checkNotNull(fieldMetrics, (Object)"fieldMetrics should not be null");
        MessageType messageType = metadata.getFileMetaData().getSchema();
        MessageType parquetTypeWithIds = ParquetUtil.getParquetTypeWithIds(metadata, nameMapping);
        Schema fileSchema = ParquetSchemaUtil.convertAndPrune(parquetTypeWithIds);
        return ParquetMetrics.metrics(fileSchema, messageType, metricsConfig, metadata, fieldMetrics);
    }

    private static MessageType getParquetTypeWithIds(ParquetMetadata metadata, NameMapping nameMapping) {
        MessageType type = metadata.getFileMetaData().getSchema();
        if (ParquetSchemaUtil.hasIds(type)) {
            return type;
        }
        if (nameMapping != null) {
            return ParquetSchemaUtil.applyNameMapping(type, nameMapping);
        }
        return ParquetSchemaUtil.addFallbackIds(type);
    }

    public static List<Long> getSplitOffsets(ParquetMetadata md) {
        ArrayList splitOffsets = Lists.newArrayListWithExpectedSize((int)md.getBlocks().size());
        for (BlockMetaData blockMetaData : md.getBlocks()) {
            splitOffsets.add(blockMetaData.getStartingPos());
        }
        Collections.sort(splitOffsets);
        return splitOffsets;
    }

    public static boolean hasNonDictionaryPages(ColumnChunkMetaData meta) {
        EncodingStats stats = meta.getEncodingStats();
        if (stats != null) {
            return stats.hasNonDictionaryEncodedPages();
        }
        HashSet encodings = Sets.newHashSet((Iterable)meta.getEncodings());
        if (encodings.remove(Encoding.PLAIN_DICTIONARY)) {
            encodings.remove(Encoding.RLE);
            encodings.remove(Encoding.BIT_PACKED);
            return !encodings.isEmpty();
        }
        return true;
    }

    public static boolean hasNoBloomFilterPages(ColumnChunkMetaData meta) {
        return meta.getBloomFilterOffset() <= 0L;
    }

    public static Dictionary readDictionary(ColumnDescriptor desc, PageReader pageSource) {
        DictionaryPage dictionaryPage = pageSource.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                return dictionaryPage.getEncoding().initDictionary(desc, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + desc, (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isIntType(PrimitiveType primitiveType) {
        if (primitiveType.getOriginalType() != null) {
            switch (primitiveType.getOriginalType()) {
                case INT_8: 
                case INT_16: 
                case INT_32: 
                case DATE: {
                    return true;
                }
            }
            return false;
        }
        return primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32;
    }

    public static long extractTimestampInt96(ByteBuffer buffer) {
        long timeOfDayNanos = buffer.getLong();
        int julianDay = buffer.getInt();
        return TimeUnit.DAYS.toMicros((long)julianDay - 2440588L) + TimeUnit.NANOSECONDS.toMicros(timeOfDayNanos);
    }
}

