/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.DoubleFieldMetrics;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.FloatFieldMetrics;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.parquet.ColumnWriter;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.TripleWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DecimalUtil;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Type;

public class ParquetValueWriters {
    private ParquetValueWriters() {
    }

    public static <T> ParquetValueWriter<T> option(Type type, int definitionLevel, ParquetValueWriter<T> writer) {
        if (type.isRepetition(Type.Repetition.OPTIONAL)) {
            return new OptionWriter<T>(definitionLevel, writer);
        }
        return writer;
    }

    public static UnboxedWriter<Boolean> booleans(ColumnDescriptor desc) {
        return new UnboxedWriter<Boolean>(desc);
    }

    public static UnboxedWriter<Byte> tinyints(ColumnDescriptor desc) {
        return new ByteWriter(desc);
    }

    public static UnboxedWriter<Short> shorts(ColumnDescriptor desc) {
        return new ShortWriter(desc);
    }

    public static <T> ParquetValueWriter<T> unboxed(ColumnDescriptor desc) {
        return new UnboxedWriter(desc);
    }

    public static UnboxedWriter<Integer> ints(ColumnDescriptor desc) {
        return new UnboxedWriter<Integer>(desc);
    }

    public static UnboxedWriter<Long> longs(ColumnDescriptor desc) {
        return new UnboxedWriter<Long>(desc);
    }

    public static UnboxedWriter<Float> floats(ColumnDescriptor desc) {
        return new FloatWriter(desc);
    }

    public static UnboxedWriter<Double> doubles(ColumnDescriptor desc) {
        return new DoubleWriter(desc);
    }

    public static PrimitiveWriter<CharSequence> strings(ColumnDescriptor desc) {
        return new StringWriter(desc);
    }

    public static PrimitiveWriter<UUID> uuids(ColumnDescriptor desc) {
        return new UUIDWriter(desc);
    }

    public static PrimitiveWriter<BigDecimal> decimalAsInteger(ColumnDescriptor desc, int precision, int scale) {
        return new IntegerDecimalWriter(desc, precision, scale);
    }

    public static PrimitiveWriter<BigDecimal> decimalAsLong(ColumnDescriptor desc, int precision, int scale) {
        return new LongDecimalWriter(desc, precision, scale);
    }

    public static PrimitiveWriter<BigDecimal> decimalAsFixed(ColumnDescriptor desc, int precision, int scale) {
        return new FixedDecimalWriter(desc, precision, scale);
    }

    public static PrimitiveWriter<ByteBuffer> byteBuffers(ColumnDescriptor desc) {
        return new BytesWriter(desc);
    }

    public static PrimitiveWriter<ByteBuffer> fixedBuffers(ColumnDescriptor desc) {
        return new FixedBufferWriter(desc);
    }

    public static <E> CollectionWriter<E> collections(int dl, int rl, ParquetValueWriter<E> writer) {
        return new CollectionWriter<E>(dl, rl, writer);
    }

    public static <K, V> MapWriter<K, V> maps(int dl, int rl, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter) {
        return new MapWriter<K, V>(dl, rl, keyWriter, valueWriter);
    }

    @Deprecated
    public static <T extends StructLike> StructWriter<T> recordWriter(List<ParquetValueWriter<?>> writers) {
        return ParquetValueWriters.recordWriter(null, writers);
    }

    public static <T extends StructLike> StructWriter<T> recordWriter(Types.StructType struct, List<ParquetValueWriter<?>> writers) {
        return new RecordWriter(struct, writers);
    }

    static int[] writerToFieldIndex(Types.StructType struct, int numWriters) {
        if (null == struct) {
            return IntStream.rangeClosed(0, numWriters).toArray();
        }
        List recordFields = struct.fields();
        int[] indexes = new int[numWriters];
        int writerIndex = 0;
        for (int pos = 0; pos < recordFields.size(); ++pos) {
            if (((Types.NestedField)recordFields.get(pos)).type().typeId() == Type.TypeID.UNKNOWN) continue;
            indexes[writerIndex] = pos;
            ++writerIndex;
        }
        return indexes;
    }

    public static class PositionDeleteStructWriter<R>
    extends StructWriter<PositionDelete<R>> {
        private final Function<CharSequence, ?> pathTransformFunc;

        public PositionDeleteStructWriter(StructWriter<?> replacedWriter, Function<CharSequence, ?> pathTransformFunc) {
            super(Arrays.asList(replacedWriter.writers));
            this.pathTransformFunc = pathTransformFunc;
        }

        @Override
        protected Object get(PositionDelete<R> delete, int index) {
            switch (index) {
                case 0: {
                    return this.pathTransformFunc.apply(delete.path());
                }
                case 1: {
                    return delete.pos();
                }
                case 2: {
                    return delete.row();
                }
            }
            throw new IllegalArgumentException("Cannot get value for invalid index: " + index);
        }
    }

    public static abstract class StructWriter<S>
    implements ParquetValueWriter<S> {
        private final int[] fieldIndexes;
        private final ParquetValueWriter<Object>[] writers;
        private final List<TripleWriter<?>> children;

        protected StructWriter(List<ParquetValueWriter<?>> writers) {
            this((Types.StructType)null, writers);
        }

        protected StructWriter(Types.StructType struct, List<ParquetValueWriter<?>> writers) {
            this(ParquetValueWriters.writerToFieldIndex(struct, writers.size()), writers);
        }

        protected StructWriter(int[] fieldIndexes, List<ParquetValueWriter<?>> writers) {
            this.fieldIndexes = fieldIndexes;
            this.writers = (ParquetValueWriter[])Array.newInstance(ParquetValueWriter.class, writers.size());
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            for (int i = 0; i < writers.size(); ++i) {
                ParquetValueWriter<?> writer = writers.get(i);
                this.writers[i] = writer;
                columnsBuilder.addAll(writer.columns());
            }
            this.children = columnsBuilder.build();
        }

        @Override
        public void write(int repetitionLevel, S value) {
            for (int i = 0; i < this.writers.length; ++i) {
                Object fieldValue = this.get(value, this.fieldIndexes[i]);
                this.writers[i].write(repetitionLevel, fieldValue);
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            for (ParquetValueWriter<Object> writer : this.writers) {
                writer.setColumnStore(columnStore);
            }
        }

        protected abstract Object get(S var1, int var2);

        @Override
        public Stream<FieldMetrics<?>> metrics() {
            return Arrays.stream(this.writers).flatMap(ParquetValueWriter::metrics);
        }
    }

    private static class MapWriter<K, V>
    extends RepeatedKeyValueWriter<Map<K, V>, K, V> {
        private MapWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter) {
            super(definitionLevel, repetitionLevel, keyWriter, valueWriter);
        }

        @Override
        protected Iterator<Map.Entry<K, V>> pairs(Map<K, V> map) {
            return map.entrySet().iterator();
        }
    }

    public static abstract class RepeatedKeyValueWriter<M, K, V>
    implements ParquetValueWriter<M> {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final ParquetValueWriter<K> keyWriter;
        private final ParquetValueWriter<V> valueWriter;
        private final List<TripleWriter<?>> children;

        protected RepeatedKeyValueWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
            this.children = ImmutableList.builder().addAll(keyWriter.columns()).addAll(valueWriter.columns()).build();
        }

        @Override
        public void write(int parentRepetition, M value) {
            Iterator<Map.Entry<K, V>> pairs = this.pairs(value);
            if (!pairs.hasNext()) {
                for (TripleWriter<?> column : this.children) {
                    column.writeNull(parentRepetition, this.definitionLevel - 1);
                }
            } else {
                boolean first = true;
                while (pairs.hasNext()) {
                    Map.Entry<K, V> pair = pairs.next();
                    int rl = this.repetitionLevel;
                    if (first) {
                        rl = parentRepetition;
                        first = false;
                    }
                    this.keyWriter.write(rl, pair.getKey());
                    this.valueWriter.write(rl, pair.getValue());
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.keyWriter.setColumnStore(columnStore);
            this.valueWriter.setColumnStore(columnStore);
        }

        protected abstract Iterator<Map.Entry<K, V>> pairs(M var1);

        @Override
        public Stream<FieldMetrics<?>> metrics() {
            return Stream.concat(this.keyWriter.metrics(), this.valueWriter.metrics());
        }
    }

    private static class CollectionWriter<E>
    extends RepeatedWriter<Collection<E>, E> {
        private CollectionWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<E> writer) {
            super(definitionLevel, repetitionLevel, writer);
        }

        @Override
        protected Iterator<E> elements(Collection<E> list) {
            return list.iterator();
        }
    }

    public static abstract class RepeatedWriter<L, E>
    implements ParquetValueWriter<L> {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final ParquetValueWriter<E> writer;
        private final List<TripleWriter<?>> children;

        protected RepeatedWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<E> writer) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.writer = writer;
            this.children = writer.columns();
        }

        @Override
        public void write(int parentRepetition, L value) {
            Iterator<E> elements = this.elements(value);
            if (!elements.hasNext()) {
                for (TripleWriter<?> column : this.children) {
                    column.writeNull(parentRepetition, this.definitionLevel - 1);
                }
            } else {
                boolean first = true;
                while (elements.hasNext()) {
                    E element = elements.next();
                    int rl = this.repetitionLevel;
                    if (first) {
                        rl = parentRepetition;
                        first = false;
                    }
                    this.writer.write(rl, element);
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.writer.setColumnStore(columnStore);
        }

        protected abstract Iterator<E> elements(L var1);

        @Override
        public Stream<FieldMetrics<?>> metrics() {
            return this.writer.metrics();
        }
    }

    static class OptionWriter<T>
    implements ParquetValueWriter<T> {
        private final int definitionLevel;
        private final ParquetValueWriter<T> writer;
        private final List<TripleWriter<?>> children;
        private long nullValueCount = 0L;

        OptionWriter(int definitionLevel, ParquetValueWriter<T> writer) {
            this.definitionLevel = definitionLevel;
            this.writer = writer;
            this.children = writer.columns();
        }

        @Override
        public void write(int repetitionLevel, T value) {
            if (value != null) {
                this.writer.write(repetitionLevel, value);
            } else {
                ++this.nullValueCount;
                for (TripleWriter<?> column : this.children) {
                    column.writeNull(repetitionLevel, this.definitionLevel - 1);
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.writer.setColumnStore(columnStore);
        }

        @Override
        public Stream<FieldMetrics<?>> metrics() {
            if (this.writer instanceof PrimitiveWriter) {
                List fieldMetricsFromWriter = this.writer.metrics().collect(Collectors.toList());
                if (fieldMetricsFromWriter.isEmpty()) {
                    return Stream.empty();
                }
                if (fieldMetricsFromWriter.size() == 1) {
                    FieldMetrics metrics = (FieldMetrics)fieldMetricsFromWriter.get(0);
                    return Stream.of(new FieldMetrics(metrics.id(), metrics.valueCount() + this.nullValueCount, this.nullValueCount, metrics.nanValueCount(), metrics.lowerBound(), metrics.upperBound()));
                }
                throw new IllegalStateException(String.format("OptionWriter should only expect at most one field metric from a primitive writer.Current number of fields: %s, primitive writer type: %s", fieldMetricsFromWriter.size(), this.writer.getClass().getSimpleName()));
            }
            return this.writer.metrics();
        }
    }

    private static class RecordWriter<T extends StructLike>
    extends StructWriter<T> {
        private RecordWriter(Types.StructType struct, List<ParquetValueWriter<?>> writers) {
            super(struct, writers);
        }

        @Override
        protected Object get(T struct, int index) {
            return struct.get(index, Object.class);
        }
    }

    private static class UUIDWriter
    extends PrimitiveWriter<UUID> {
        private static final ThreadLocal<ByteBuffer> BUFFER = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        });

        private UUIDWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, UUID value) {
            ByteBuffer buffer = UUIDUtil.convertToByteBuffer((UUID)value, (ByteBuffer)BUFFER.get());
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteBuffer((ByteBuffer)buffer));
        }
    }

    private static class StringWriter
    extends PrimitiveWriter<CharSequence> {
        private StringWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, CharSequence value) {
            if (value instanceof Utf8) {
                Utf8 utf8 = (Utf8)value;
                this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength()));
            } else {
                this.column.writeBinary(repetitionLevel, Binary.fromString((String)value.toString()));
            }
        }
    }

    private static class FixedBufferWriter
    extends PrimitiveWriter<ByteBuffer> {
        private final int length;

        private FixedBufferWriter(ColumnDescriptor desc) {
            super(desc);
            this.length = desc.getPrimitiveType().getTypeLength();
        }

        @Override
        public void write(int repetitionLevel, ByteBuffer buffer) {
            Preconditions.checkArgument((buffer.remaining() == this.length ? 1 : 0) != 0, (String)"Cannot write byte buffer of length %s as fixed[%s]", (int)buffer.remaining(), (int)this.length);
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteBuffer((ByteBuffer)buffer));
        }
    }

    private static class BytesWriter
    extends PrimitiveWriter<ByteBuffer> {
        private BytesWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, ByteBuffer buffer) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteBuffer((ByteBuffer)buffer));
        }
    }

    private static class FixedDecimalWriter
    extends PrimitiveWriter<BigDecimal> {
        private final int precision;
        private final int scale;
        private final ThreadLocal<byte[]> bytes;

        private FixedDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
            this.bytes = ThreadLocal.withInitial(() -> new byte[TypeUtil.decimalRequiredBytes((int)precision)]);
        }

        @Override
        public void write(int repetitionLevel, BigDecimal decimal) {
            byte[] binary = DecimalUtil.toReusedFixLengthBytes((int)this.precision, (int)this.scale, (BigDecimal)decimal, (byte[])this.bytes.get());
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])binary));
        }
    }

    private static class LongDecimalWriter
    extends PrimitiveWriter<BigDecimal> {
        private final int precision;
        private final int scale;

        private LongDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void write(int repetitionLevel, BigDecimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeLong(repetitionLevel, decimal.unscaledValue().longValue());
        }
    }

    private static class IntegerDecimalWriter
    extends PrimitiveWriter<BigDecimal> {
        private final int precision;
        private final int scale;

        private IntegerDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void write(int repetitionLevel, BigDecimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeInteger(repetitionLevel, decimal.unscaledValue().intValue());
        }
    }

    private static class ShortWriter
    extends UnboxedWriter<Short> {
        private ShortWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, Short value) {
            this.writeInteger(repetitionLevel, value.intValue());
        }
    }

    private static class ByteWriter
    extends UnboxedWriter<Byte> {
        private ByteWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, Byte value) {
            this.writeInteger(repetitionLevel, value.intValue());
        }
    }

    private static class DoubleWriter
    extends UnboxedWriter<Double> {
        private final DoubleFieldMetrics.Builder doubleFieldMetricsBuilder;

        private DoubleWriter(ColumnDescriptor desc) {
            super(desc);
            int id = desc.getPrimitiveType().getId().intValue();
            this.doubleFieldMetricsBuilder = new DoubleFieldMetrics.Builder(id);
        }

        @Override
        public void write(int repetitionLevel, Double value) {
            this.writeDouble(repetitionLevel, value);
            this.doubleFieldMetricsBuilder.addValue(value.doubleValue());
        }

        @Override
        public Stream<FieldMetrics<?>> metrics() {
            return Stream.of(this.doubleFieldMetricsBuilder.build());
        }
    }

    private static class FloatWriter
    extends UnboxedWriter<Float> {
        private final FloatFieldMetrics.Builder floatFieldMetricsBuilder;

        private FloatWriter(ColumnDescriptor desc) {
            super(desc);
            int id = desc.getPrimitiveType().getId().intValue();
            this.floatFieldMetricsBuilder = new FloatFieldMetrics.Builder(id);
        }

        @Override
        public void write(int repetitionLevel, Float value) {
            this.writeFloat(repetitionLevel, value.floatValue());
            this.floatFieldMetricsBuilder.addValue(value.floatValue());
        }

        @Override
        public Stream<FieldMetrics<?>> metrics() {
            return Stream.of(this.floatFieldMetricsBuilder.build());
        }
    }

    private static class UnboxedWriter<T>
    extends PrimitiveWriter<T> {
        private UnboxedWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void writeInteger(int repetitionLevel, int value) {
            this.column.writeInteger(repetitionLevel, value);
        }

        public void writeFloat(int repetitionLevel, float value) {
            this.column.writeFloat(repetitionLevel, value);
        }

        public void writeDouble(int repetitionLevel, double value) {
            this.column.writeDouble(repetitionLevel, value);
        }
    }

    public static abstract class PrimitiveWriter<T>
    implements ParquetValueWriter<T> {
        protected final ColumnWriter<T> column;
        private final List<TripleWriter<?>> children;

        protected PrimitiveWriter(ColumnDescriptor desc) {
            this.column = ColumnWriter.newWriter(desc);
            this.children = ImmutableList.of(this.column);
        }

        @Override
        public void write(int repetitionLevel, T value) {
            this.column.write(repetitionLevel, value);
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.column.setColumnStore(columnStore);
        }
    }
}

