/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.parquet.ParquetMetrics;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

@Deprecated
public class ParquetWriteAdapter<D>
implements FileAppender<D> {
    private ParquetWriter<D> writer;
    private final MetricsConfig metricsConfig;
    private ParquetMetadata footer;

    public ParquetWriteAdapter(ParquetWriter<D> writer, MetricsConfig metricsConfig) {
        this.writer = writer;
        this.metricsConfig = metricsConfig;
    }

    public void add(D datum) {
        try {
            this.writer.write(datum);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write record %s", new Object[]{datum});
        }
    }

    public Metrics metrics() {
        Preconditions.checkState((this.footer != null ? 1 : 0) != 0, (Object)"Cannot produce metrics until closed");
        MessageType messageType = this.footer.getFileMetaData().getSchema();
        Schema schema = ParquetSchemaUtil.convert(messageType);
        return ParquetMetrics.metrics(schema, messageType, this.metricsConfig, this.footer, Stream.empty());
    }

    public long length() {
        return this.writer.getDataSize();
    }

    public List<Long> splitOffsets() {
        return ParquetUtil.getSplitOffsets(this.writer.getFooter());
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.footer = this.writer.getFooter();
            this.writer = null;
        }
    }
}

