/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.snowflake.JdbcSnowflakeClient;
import org.apache.iceberg.snowflake.NamespaceHelpers;
import org.apache.iceberg.snowflake.SnowflakeClient;
import org.apache.iceberg.snowflake.SnowflakeIdentifier;
import org.apache.iceberg.snowflake.SnowflakeTableOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Configurable<Object> {
    private static final String DEFAULT_CATALOG_NAME = "snowflake_catalog";
    private static final String DEFAULT_FILE_IO_IMPL = "org.apache.iceberg.io.ResolvingFileIO";
    private static final String JDBC_APPLICATION_PROPERTY = "application";
    private static final String JDBC_USER_AGENT_SUFFIX_PROPERTY = "user_agent_suffix";
    private static final String APP_IDENTIFIER = "iceberg-snowflake-catalog";
    private static final int UNIQUE_ID_LENGTH = 20;
    private static final Logger LOG = LoggerFactory.getLogger(SnowflakeCatalog.class);
    private CloseableGroup closeableGroup;
    private Object conf;
    private String catalogName;
    private Map<String, String> catalogProperties;
    private FileIOFactory fileIOFactory;
    private SnowflakeClient snowflakeClient;

    public List<TableIdentifier> listTables(Namespace namespace) {
        SnowflakeIdentifier scope = NamespaceHelpers.toSnowflakeIdentifier(namespace);
        Preconditions.checkArgument((scope.type() == SnowflakeIdentifier.Type.SCHEMA ? 1 : 0) != 0, (String)"listTables must be at SCHEMA level; got %s from namespace %s", (Object)scope, (Object)namespace);
        List<SnowflakeIdentifier> sfTables = this.snowflakeClient.listIcebergTables(scope);
        return sfTables.stream().map(NamespaceHelpers::toIcebergTableIdentifier).collect(Collectors.toList());
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support dropTable");
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support renameTable");
    }

    public void initialize(String name, Map<String, String> properties) {
        String uri = properties.get("uri");
        Preconditions.checkArgument((null != uri ? 1 : 0) != 0, (Object)"JDBC connection URI is required");
        try {
            Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warn("Failed to load expected JDBC SnowflakeDriver - if queries fail by failing to find a suitable driver for jdbc:snowflake:// URIs, you must add the Snowflake  JDBC driver to your jars/packages", (Throwable)cnfe);
        }
        String uniqueId = UUID.randomUUID().toString().replace("-", "").substring(0, 20);
        String uniqueAppIdentifier = "iceberg-snowflake-catalog_" + uniqueId;
        String userAgentSuffix = IcebergBuild.fullVersion() + " " + uniqueAppIdentifier;
        properties.put("jdbc.application", uniqueAppIdentifier);
        properties.put("jdbc.user_agent_suffix", userAgentSuffix);
        JdbcClientPool connectionPool = new JdbcClientPool(uri, properties);
        this.initialize(name, new JdbcSnowflakeClient(connectionPool), new FileIOFactory(), properties);
    }

    void initialize(String name, SnowflakeClient snowflakeClient, FileIOFactory fileIOFactory, Map<String, String> properties) {
        Preconditions.checkArgument((null != snowflakeClient ? 1 : 0) != 0, (Object)"snowflakeClient must be non-null");
        Preconditions.checkArgument((null != fileIOFactory ? 1 : 0) != 0, (Object)"fileIOFactory must be non-null");
        this.catalogName = name == null ? DEFAULT_CATALOG_NAME : name;
        this.snowflakeClient = snowflakeClient;
        this.fileIOFactory = fileIOFactory;
        this.catalogProperties = properties;
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((Closeable)snowflakeClient);
        this.closeableGroup.addCloseable((Closeable)this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
    }

    public void close() throws IOException {
        if (null != this.closeableGroup) {
            this.closeableGroup.close();
        }
    }

    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support createNamespace");
    }

    public List<Namespace> listNamespaces(Namespace namespace) {
        SnowflakeIdentifier scope = NamespaceHelpers.toSnowflakeIdentifier(namespace);
        List<SnowflakeIdentifier> results = null;
        switch (scope.type()) {
            case ROOT: {
                results = this.snowflakeClient.listDatabases();
                break;
            }
            case DATABASE: {
                results = this.snowflakeClient.listSchemas(scope);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("listNamespaces must be at either ROOT or DATABASE level; got %s from namespace %s", scope, namespace));
            }
        }
        return results.stream().map(NamespaceHelpers::toIcebergNamespace).collect(Collectors.toList());
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        boolean namespaceExists;
        SnowflakeIdentifier id = NamespaceHelpers.toSnowflakeIdentifier(namespace);
        switch (id.type()) {
            case DATABASE: {
                namespaceExists = this.snowflakeClient.databaseExists(id);
                break;
            }
            case SCHEMA: {
                namespaceExists = this.snowflakeClient.schemaExists(id);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("loadNamespaceMetadata must be at either DATABASE or SCHEMA level; got %s from namespace %s", id, namespace));
            }
        }
        if (namespaceExists) {
            return ImmutableMap.of();
        }
        throw new NoSuchNamespaceException("Namespace '%s' with snowflake identifier '%s' doesn't exist", new Object[]{namespace, id});
    }

    public boolean dropNamespace(Namespace namespace) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support dropNamespace");
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support setProperties");
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support removeProperties");
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        String fileIOImpl = DEFAULT_FILE_IO_IMPL;
        if (this.catalogProperties.containsKey("io-impl")) {
            fileIOImpl = this.catalogProperties.get("io-impl");
        }
        FileIO fileIO = this.fileIOFactory.newFileIO(fileIOImpl, this.catalogProperties, this.conf);
        this.closeableGroup.addCloseable((Closeable)fileIO);
        return new SnowflakeTableOperations(this.snowflakeClient, fileIO, this.catalogName, tableIdentifier);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        throw new UnsupportedOperationException("SnowflakeCatalog does not currently support defaultWarehouseLocation");
    }

    public void setConf(Object conf) {
        this.conf = conf;
    }

    static class FileIOFactory {
        FileIOFactory() {
        }

        public FileIO newFileIO(String impl, Map<String, String> properties, Object hadoopConf) {
            return CatalogUtil.loadFileIO((String)impl, properties, (Object)hadoopConf);
        }
    }
}

