/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkParquetReaders {
    private SparkParquetReaders() {
    }

    public static ParquetValueReader<InternalRow> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return SparkParquetReaders.buildReader(expectedSchema, fileSchema, ImmutableMap.of());
    }

    public static ParquetValueReader<InternalRow> buildReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        if (ParquetSchemaUtil.hasIds((MessageType)fileSchema)) {
            return (ParquetValueReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new ReadBuilder(fileSchema, idToConstant));
        }
        return (ParquetValueReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new FallbackReadBuilder(fileSchema, idToConstant));
    }

    private static class ReusableArrayData
    extends ArrayData {
        private static final Object[] EMPTY = new Object[0];
        private Object[] values = EMPTY;
        private int numElements = 0;

        private ReusableArrayData() {
        }

        private void grow() {
            if (this.values.length == 0) {
                this.values = new Object[20];
            } else {
                Object[] old = this.values;
                this.values = new Object[old.length << 2];
                System.arraycopy(old, 0, this.values, 0, old.length);
            }
        }

        private int capacity() {
            return this.values.length;
        }

        public void setNumElements(int numElements) {
            this.numElements = numElements;
        }

        public Object get(int ordinal, DataType dataType) {
            return this.values[ordinal];
        }

        public int numElements() {
            return this.numElements;
        }

        public ArrayData copy() {
            return new GenericArrayData(this.array());
        }

        public Object[] array() {
            return Arrays.copyOfRange(this.values, 0, this.numElements);
        }

        public void setNullAt(int i) {
            this.values[i] = null;
        }

        public void update(int ordinal, Object value) {
            this.values[ordinal] = value;
        }

        public boolean isNullAt(int ordinal) {
            return null == this.values[ordinal];
        }

        public boolean getBoolean(int ordinal) {
            return (Boolean)this.values[ordinal];
        }

        public byte getByte(int ordinal) {
            return (Byte)this.values[ordinal];
        }

        public short getShort(int ordinal) {
            return (Short)this.values[ordinal];
        }

        public int getInt(int ordinal) {
            return (Integer)this.values[ordinal];
        }

        public long getLong(int ordinal) {
            return (Long)this.values[ordinal];
        }

        public float getFloat(int ordinal) {
            return ((Float)this.values[ordinal]).floatValue();
        }

        public double getDouble(int ordinal) {
            return (Double)this.values[ordinal];
        }

        public Decimal getDecimal(int ordinal, int precision, int scale) {
            return (Decimal)this.values[ordinal];
        }

        public UTF8String getUTF8String(int ordinal) {
            return (UTF8String)this.values[ordinal];
        }

        public byte[] getBinary(int ordinal) {
            return (byte[])this.values[ordinal];
        }

        public CalendarInterval getInterval(int ordinal) {
            return (CalendarInterval)this.values[ordinal];
        }

        public InternalRow getStruct(int ordinal, int numFields) {
            return (InternalRow)this.values[ordinal];
        }

        public ArrayData getArray(int ordinal) {
            return (ArrayData)this.values[ordinal];
        }

        public MapData getMap(int ordinal) {
            return (MapData)this.values[ordinal];
        }
    }

    private static class ReusableMapData
    extends MapData {
        private final ReusableArrayData keys = new ReusableArrayData();
        private final ReusableArrayData values = new ReusableArrayData();
        private int numElements;

        private ReusableMapData() {
        }

        private void grow() {
            this.keys.grow();
            this.values.grow();
        }

        private int capacity() {
            return this.keys.capacity();
        }

        public void setNumElements(int numElements) {
            this.numElements = numElements;
            this.keys.setNumElements(numElements);
            this.values.setNumElements(numElements);
        }

        public int numElements() {
            return this.numElements;
        }

        public MapData copy() {
            return new ArrayBasedMapData(this.keyArray().copy(), this.valueArray().copy());
        }

        public ReusableArrayData keyArray() {
            return this.keys;
        }

        public ReusableArrayData valueArray() {
            return this.values;
        }
    }

    private static class InternalRowReader
    extends ParquetValueReaders.StructReader<InternalRow, GenericInternalRow> {
        private final int numFields;

        InternalRowReader(List<org.apache.parquet.schema.Type> types, List<ParquetValueReader<?>> readers) {
            super(types, readers);
            this.numFields = readers.size();
        }

        protected GenericInternalRow newStructData(InternalRow reuse) {
            if (reuse instanceof GenericInternalRow) {
                return (GenericInternalRow)reuse;
            }
            return new GenericInternalRow(this.numFields);
        }

        protected Object getField(GenericInternalRow intermediate, int pos) {
            return intermediate.genericGet(pos);
        }

        protected InternalRow buildStruct(GenericInternalRow struct) {
            return struct;
        }

        protected void set(GenericInternalRow row, int pos, Object value) {
            row.update(pos, value);
        }

        protected void setNull(GenericInternalRow row, int pos) {
            row.setNullAt(pos);
        }

        protected void setBoolean(GenericInternalRow row, int pos, boolean value) {
            row.setBoolean(pos, value);
        }

        protected void setInteger(GenericInternalRow row, int pos, int value) {
            row.setInt(pos, value);
        }

        protected void setLong(GenericInternalRow row, int pos, long value) {
            row.setLong(pos, value);
        }

        protected void setFloat(GenericInternalRow row, int pos, float value) {
            row.setFloat(pos, value);
        }

        protected void setDouble(GenericInternalRow row, int pos, double value) {
            row.setDouble(pos, value);
        }
    }

    private static class MapReader<K, V>
    extends ParquetValueReaders.RepeatedKeyValueReader<MapData, ReusableMapData, K, V> {
        private int readPos = 0;
        private int writePos = 0;
        private final ParquetValueReaders.ReusableEntry<K, V> entry = new ParquetValueReaders.ReusableEntry();
        private final ParquetValueReaders.ReusableEntry<K, V> nullEntry = new ParquetValueReaders.ReusableEntry();

        MapReader(int definitionLevel, int repetitionLevel, ParquetValueReader<K> keyReader, ParquetValueReader<V> valueReader) {
            super(definitionLevel, repetitionLevel, keyReader, valueReader);
        }

        protected ReusableMapData newMapData(MapData reuse) {
            this.readPos = 0;
            this.writePos = 0;
            if (reuse instanceof ReusableMapData) {
                return (ReusableMapData)reuse;
            }
            return new ReusableMapData();
        }

        protected Map.Entry<K, V> getPair(ReusableMapData map) {
            ParquetValueReaders.ReusableEntry<K, V> kv = this.nullEntry;
            if (this.readPos < map.capacity()) {
                this.entry.set(map.keys.values[this.readPos], map.values.values[this.readPos]);
                kv = this.entry;
            }
            ++this.readPos;
            return kv;
        }

        protected void addPair(ReusableMapData map, K key, V value) {
            if (this.writePos >= map.capacity()) {
                map.grow();
            }
            ((ReusableArrayData)((ReusableMapData)map).keys).values[this.writePos] = key;
            ((ReusableArrayData)((ReusableMapData)map).values).values[this.writePos] = value;
            ++this.writePos;
        }

        protected MapData buildMap(ReusableMapData map) {
            map.setNumElements(this.writePos);
            return map;
        }
    }

    private static class ArrayReader<E>
    extends ParquetValueReaders.RepeatedReader<ArrayData, ReusableArrayData, E> {
        private int readPos = 0;
        private int writePos = 0;

        ArrayReader(int definitionLevel, int repetitionLevel, ParquetValueReader<E> reader) {
            super(definitionLevel, repetitionLevel, reader);
        }

        protected ReusableArrayData newListData(ArrayData reuse) {
            this.readPos = 0;
            this.writePos = 0;
            if (reuse instanceof ReusableArrayData) {
                return (ReusableArrayData)reuse;
            }
            return new ReusableArrayData();
        }

        protected E getElement(ReusableArrayData list) {
            Object value = null;
            if (this.readPos < list.capacity()) {
                value = list.values[this.readPos];
            }
            ++this.readPos;
            return (E)value;
        }

        protected void addElement(ReusableArrayData reused, E element) {
            if (this.writePos >= reused.capacity()) {
                reused.grow();
            }
            ((ReusableArrayData)reused).values[this.writePos] = element;
            ++this.writePos;
        }

        protected ArrayData buildList(ReusableArrayData list) {
            list.setNumElements(this.writePos);
            return list;
        }
    }

    private static class StringReader
    extends ParquetValueReaders.PrimitiveReader<UTF8String> {
        StringReader(ColumnDescriptor desc) {
            super(desc);
        }

        public UTF8String read(UTF8String ignored) {
            Binary binary = this.column.nextBinary();
            ByteBuffer buffer = binary.toByteBuffer();
            if (buffer.hasArray()) {
                return UTF8String.fromBytes((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)buffer.remaining());
            }
            return UTF8String.fromBytes((byte[])binary.getBytes());
        }
    }

    private static class TimestampInt96Reader
    extends ParquetValueReaders.UnboxedReader<Long> {
        private static final long UNIX_EPOCH_JULIAN = 2440588L;

        TimestampInt96Reader(ColumnDescriptor desc) {
            super(desc);
        }

        public Long read(Long ignored) {
            return this.readLong();
        }

        public long readLong() {
            ByteBuffer byteBuffer = this.column.nextBinary().toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = byteBuffer.getLong();
            int julianDay = byteBuffer.getInt();
            return TimeUnit.DAYS.toMicros((long)julianDay - 2440588L) + TimeUnit.NANOSECONDS.toMicros(timeOfDayNanos);
        }
    }

    private static class TimestampMillisReader
    extends ParquetValueReaders.UnboxedReader<Long> {
        TimestampMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        public Long read(Long ignored) {
            return this.readLong();
        }

        public long readLong() {
            return 1000L * this.column.nextLong();
        }
    }

    private static class LongDecimalReader
    extends ParquetValueReaders.PrimitiveReader<Decimal> {
        private final int precision;
        private final int scale;

        LongDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public Decimal read(Decimal ignored) {
            return Decimal.apply((long)this.column.nextLong(), (int)this.precision, (int)this.scale);
        }
    }

    private static class IntegerDecimalReader
    extends ParquetValueReaders.PrimitiveReader<Decimal> {
        private final int precision;
        private final int scale;

        IntegerDecimalReader(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public Decimal read(Decimal ignored) {
            return Decimal.apply((long)this.column.nextInteger(), (int)this.precision, (int)this.scale);
        }
    }

    private static class BinaryDecimalReader
    extends ParquetValueReaders.PrimitiveReader<Decimal> {
        private final int scale;

        BinaryDecimalReader(ColumnDescriptor desc, int scale) {
            super(desc);
            this.scale = scale;
        }

        public Decimal read(Decimal ignored) {
            Binary binary = this.column.nextBinary();
            return Decimal.fromDecimal((Object)new BigDecimal(new BigInteger(binary.getBytes()), this.scale));
        }
    }

    private static class ReadBuilder
    extends TypeWithSchemaVisitor<ParquetValueReader<?>> {
        private final MessageType type;
        private final Map<Integer, ?> idToConstant;

        ReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            this.type = type;
            this.idToConstant = idToConstant;
        }

        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return this.struct(expected, message.asGroupType(), fieldReaders);
        }

        public ParquetValueReader<?> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            HashMap readersById = Maps.newHashMap();
            HashMap typesById = Maps.newHashMap();
            List fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                org.apache.parquet.schema.Type fieldType = (org.apache.parquet.schema.Type)fields.get(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                if (fieldType.getId() == null) continue;
                int id = fieldType.getId().intValue();
                readersById.put(id, ParquetValueReaders.option((org.apache.parquet.schema.Type)fieldType, (int)fieldD, fieldReaders.get(i)));
                typesById.put(id, fieldType);
            }
            List expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList reorderedFields = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            ArrayList types = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            Iterator iterator = expectedFields.iterator();
            while (iterator.hasNext()) {
                Types.NestedField field = (Types.NestedField)iterator.next();
                int id = field.fieldId();
                if (this.idToConstant.containsKey(id)) {
                    reorderedFields.add(ParquetValueReaders.constant(this.idToConstant.get(id)));
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.ROW_POSITION.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.position());
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.IS_DELETED.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.constant((Object)false));
                    types.add(null);
                    continue;
                }
                ParquetValueReader reader = (ParquetValueReader)readersById.get(id);
                if (reader != null) {
                    reorderedFields.add(reader);
                    types.add(typesById.get(id));
                    continue;
                }
                reorderedFields.add(ParquetValueReaders.nulls());
                types.add(null);
            }
            return new InternalRowReader(types, reorderedFields);
        }

        public ParquetValueReader<?> list(Types.ListType expectedList, GroupType array, ParquetValueReader<?> elementReader) {
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type elementType = ParquetSchemaUtil.determineListElementType((GroupType)array);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName())) - 1;
            return new ArrayReader(repeatedD, repeatedR, ParquetValueReaders.option((org.apache.parquet.schema.Type)elementType, (int)elementD, elementReader));
        }

        public ParquetValueReader<?> map(Types.MapType expectedMap, GroupType map, ParquetValueReader<?> keyReader, ParquetValueReader<?> valueReader) {
            GroupType repeatedKeyValue = ((org.apache.parquet.schema.Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName())) - 1;
            org.apache.parquet.schema.Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName())) - 1;
            return new MapReader(repeatedD, repeatedR, ParquetValueReaders.option((org.apache.parquet.schema.Type)keyType, (int)keyD, keyReader), ParquetValueReaders.option((org.apache.parquet.schema.Type)valueType, (int)valueD, valueReader));
        }

        public ParquetValueReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return new StringReader(desc);
                    }
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        if (expected != null && expected.typeId() == Types.LongType.get().typeId()) {
                            return new ParquetValueReaders.IntAsLongReader(desc);
                        }
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case DATE: 
                    case INT_64: 
                    case TIMESTAMP_MICROS: {
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case TIMESTAMP_MILLIS: {
                        return new TimestampMillisReader(desc);
                    }
                    case DECIMAL: {
                        DecimalMetadata decimal = primitive.getDecimalMetadata();
                        switch (primitive.getPrimitiveTypeName()) {
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return new BinaryDecimalReader(desc, decimal.getScale());
                            }
                            case INT64: {
                                return new LongDecimalReader(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case INT32: {
                                return new IntegerDecimalReader(desc, decimal.getPrecision(), decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + primitive.getPrimitiveTypeName());
                    }
                    case BSON: {
                        return new ParquetValueReaders.ByteArrayReader(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + primitive.getOriginalType());
            }
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return new ParquetValueReaders.ByteArrayReader(desc);
                }
                case INT32: {
                    if (expected != null && expected.typeId() == Type.TypeID.LONG) {
                        return new ParquetValueReaders.IntAsLongReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case FLOAT: {
                    if (expected != null && expected.typeId() == Type.TypeID.DOUBLE) {
                        return new ParquetValueReaders.FloatAsDoubleReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT64: 
                case BOOLEAN: 
                case DOUBLE: {
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT96: {
                    return new TimestampInt96Reader(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }

        protected MessageType type() {
            return this.type;
        }
    }

    private static class FallbackReadBuilder
    extends ReadBuilder {
        FallbackReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            super(type, idToConstant);
        }

        @Override
        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return super.struct(expected, (GroupType)message, fieldReaders);
        }

        @Override
        public ParquetValueReader<?> struct(Types.StructType ignored, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fieldReaders.size());
            ArrayList types = Lists.newArrayListWithExpectedSize((int)fieldReaders.size());
            List fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                org.apache.parquet.schema.Type fieldType = (org.apache.parquet.schema.Type)fields.get(i);
                int fieldD = this.type().getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                newFields.add(ParquetValueReaders.option((org.apache.parquet.schema.Type)fieldType, (int)fieldD, fieldReaders.get(i)));
                types.add(fieldType);
            }
            return new InternalRowReader(types, newFields);
        }
    }
}

