/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.arrow.vectorized.VectorizedReaderBuilder;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.data.vectorized.ColumnarBatchReader;
import org.apache.iceberg.types.Type;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;

public class VectorizedSparkParquetReaders {
    private VectorizedSparkParquetReaders() {
    }

    public static ColumnarBatchReader buildReader(Schema expectedSchema, MessageType fileSchema, boolean setArrowValidityVector) {
        return VectorizedSparkParquetReaders.buildReader(expectedSchema, fileSchema, setArrowValidityVector, Maps.newHashMap());
    }

    public static ColumnarBatchReader buildReader(Schema expectedSchema, MessageType fileSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant) {
        return (ColumnarBatchReader)((Object)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new VectorizedReaderBuilder(expectedSchema, fileSchema, setArrowValidityVector, idToConstant, ColumnarBatchReader::new)));
    }

    public static ColumnarBatchReader buildReader(Schema expectedSchema, MessageType fileSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, DeleteFilter<InternalRow> deleteFilter) {
        return (ColumnarBatchReader)((Object)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new ReaderBuilder(expectedSchema, fileSchema, setArrowValidityVector, idToConstant, ColumnarBatchReader::new, deleteFilter)));
    }

    private static class ReaderBuilder
    extends VectorizedReaderBuilder {
        private final DeleteFilter<InternalRow> deleteFilter;

        ReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory, DeleteFilter<InternalRow> deleteFilter) {
            super(expectedSchema, parquetSchema, setArrowValidityVector, idToConstant, readerFactory);
            this.deleteFilter = deleteFilter;
        }

        protected VectorizedReader<?> vectorizedReader(List<VectorizedReader<?>> reorderedFields) {
            VectorizedReader reader = super.vectorizedReader(reorderedFields);
            if (this.deleteFilter != null) {
                ((ColumnarBatchReader)reader).setDeleteFilter(this.deleteFilter);
            }
            return reader;
        }
    }
}

