/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.Set;
import org.apache.arrow.vector.NullCheckingForGet;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkOrcReaders;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkParquetReaders;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.sql.vectorized.ColumnarBatch;

abstract class BaseBatchReader<T extends ScanTask>
extends BaseReader<ColumnarBatch, T> {
    private final int batchSize;

    BaseBatchReader(Table table, ScanTaskGroup<T> taskGroup, Schema expectedSchema, boolean caseSensitive, int batchSize) {
        super(table, taskGroup, expectedSchema, caseSensitive);
        this.batchSize = batchSize;
    }

    protected CloseableIterable<ColumnarBatch> newBatchIterable(InputFile inputFile, FileFormat format, long start, long length, Expression residual, Map<Integer, ?> idToConstant, BaseReader.SparkDeleteFilter deleteFilter) {
        switch (format) {
            case PARQUET: {
                return this.newParquetIterable(inputFile, start, length, residual, idToConstant, deleteFilter);
            }
            case ORC: {
                return this.newOrcIterable(inputFile, start, length, residual, idToConstant);
            }
        }
        throw new UnsupportedOperationException("Format: " + format + " not supported for batched reads");
    }

    private CloseableIterable<ColumnarBatch> newParquetIterable(InputFile inputFile, long start, long length, Expression residual, Map<Integer, ?> idToConstant, BaseReader.SparkDeleteFilter deleteFilter) {
        Schema requiredSchema = deleteFilter != null ? deleteFilter.requiredSchema() : this.expectedSchema();
        return Parquet.read((InputFile)inputFile).project(requiredSchema).split(start, length).createBatchedReaderFunc(fileSchema -> VectorizedSparkParquetReaders.buildReader(requiredSchema, fileSchema, NullCheckingForGet.NULL_CHECKING_ENABLED, idToConstant, deleteFilter)).recordsPerBatch(this.batchSize).filter(residual).caseSensitive(this.caseSensitive()).reuseContainers().withNameMapping(this.nameMapping()).build();
    }

    private CloseableIterable<ColumnarBatch> newOrcIterable(InputFile inputFile, long start, long length, Expression residual, Map<Integer, ?> idToConstant) {
        Set<Integer> constantFieldIds = idToConstant.keySet();
        Set metadataFieldIds = MetadataColumns.metadataFieldIds();
        Sets.SetView constantAndMetadataFieldIds = Sets.union(constantFieldIds, (Set)metadataFieldIds);
        Schema schemaWithoutConstantAndMetadataFields = TypeUtil.selectNot((Schema)this.expectedSchema(), (Set)constantAndMetadataFieldIds);
        return ORC.read((InputFile)inputFile).project(schemaWithoutConstantAndMetadataFields).split(start, length).createBatchedReaderFunc(fileSchema -> VectorizedSparkOrcReaders.buildReader(this.expectedSchema(), fileSchema, idToConstant)).recordsPerBatch(this.batchSize).filter(residual).caseSensitive(this.caseSensitive()).withNameMapping(this.nameMapping()).build();
    }
}

