/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.BasePositionDeltaWriter;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.PositionDeltaWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.CommitMetadata;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.iceberg.spark.source.SparkFileWriterFactory;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.StructProjection;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.iceberg.write.DeltaBatchWrite;
import org.apache.spark.sql.connector.iceberg.write.DeltaWrite;
import org.apache.spark.sql.connector.iceberg.write.DeltaWriter;
import org.apache.spark.sql.connector.iceberg.write.DeltaWriterFactory;
import org.apache.spark.sql.connector.iceberg.write.ExtendedLogicalWriteInfo;
import org.apache.spark.sql.connector.iceberg.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkPositionDeltaWrite
implements DeltaWrite,
RequiresDistributionAndOrdering {
    private static final Logger LOG = LoggerFactory.getLogger(SparkPositionDeltaWrite.class);
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final RowLevelOperation.Command command;
    private final SparkBatchQueryScan scan;
    private final IsolationLevel isolationLevel;
    private final Context context;
    private final String applicationId;
    private final boolean wapEnabled;
    private final String wapId;
    private final Map<String, String> extraSnapshotMetadata;
    private final Distribution requiredDistribution;
    private final SortOrder[] requiredOrdering;
    private boolean cleanupOnAbort = true;

    SparkPositionDeltaWrite(SparkSession spark, Table table, RowLevelOperation.Command command, SparkBatchQueryScan scan, IsolationLevel isolationLevel, SparkWriteConf writeConf, ExtendedLogicalWriteInfo info, Schema dataSchema, Distribution requiredDistribution, SortOrder[] requiredOrdering) {
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.command = command;
        this.scan = scan;
        this.isolationLevel = isolationLevel;
        this.context = new Context(dataSchema, writeConf, info);
        this.applicationId = spark.sparkContext().applicationId();
        this.wapEnabled = writeConf.wapEnabled();
        this.wapId = writeConf.wapId();
        this.extraSnapshotMetadata = writeConf.extraSnapshotMetadata();
        this.requiredDistribution = requiredDistribution;
        this.requiredOrdering = requiredOrdering;
    }

    public Distribution requiredDistribution() {
        return this.requiredDistribution;
    }

    public SortOrder[] requiredOrdering() {
        return this.requiredOrdering;
    }

    @Override
    public DeltaBatchWrite toBatch() {
        return new PositionDeltaBatchWrite();
    }

    private static <T extends ContentFile<T>> void cleanFiles(FileIO io, Iterable<T> files) {
        Tasks.foreach(files).executeWith(ThreadPools.getWorkerPool()).throwFailureWhenFinished().noRetry().run(file -> io.deleteFile(file.path().toString()));
    }

    private static class Context
    implements Serializable {
        private final Schema dataSchema;
        private final StructType dataSparkType;
        private final FileFormat dataFileFormat;
        private final long targetDataFileSize;
        private final StructType deleteSparkType;
        private final StructType metadataSparkType;
        private final FileFormat deleteFileFormat;
        private final long targetDeleteFileSize;
        private final boolean fanoutWriterEnabled;

        Context(Schema dataSchema, SparkWriteConf writeConf, ExtendedLogicalWriteInfo info) {
            this.dataSchema = dataSchema;
            this.dataSparkType = info.schema();
            this.dataFileFormat = writeConf.dataFileFormat();
            this.targetDataFileSize = writeConf.targetDataFileSize();
            this.deleteSparkType = info.rowIdSchema();
            this.deleteFileFormat = writeConf.deleteFileFormat();
            this.targetDeleteFileSize = writeConf.targetDeleteFileSize();
            this.metadataSparkType = info.metadataSchema();
            this.fanoutWriterEnabled = writeConf.fanoutWriterEnabled();
        }

        Schema dataSchema() {
            return this.dataSchema;
        }

        StructType dataSparkType() {
            return this.dataSparkType;
        }

        FileFormat dataFileFormat() {
            return this.dataFileFormat;
        }

        long targetDataFileSize() {
            return this.targetDataFileSize;
        }

        StructType deleteSparkType() {
            return this.deleteSparkType;
        }

        StructType metadataSparkType() {
            return this.metadataSparkType;
        }

        FileFormat deleteFileFormat() {
            return this.deleteFileFormat;
        }

        long targetDeleteFileSize() {
            return this.targetDeleteFileSize;
        }

        boolean fanoutWriterEnabled() {
            return this.fanoutWriterEnabled;
        }
    }

    private static class PartitionedDeltaWriter
    extends DeleteAndDataDeltaWriter {
        private final PartitionSpec dataSpec;
        private final PartitionKey dataPartitionKey;
        private final InternalRowWrapper internalRowDataWrapper;

        PartitionedDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory dataFileFactory, OutputFileFactory deleteFileFactory, Context context) {
            super(table, writerFactory, dataFileFactory, deleteFileFactory, context);
            this.dataSpec = table.spec();
            this.dataPartitionKey = new PartitionKey(this.dataSpec, context.dataSchema());
            this.internalRowDataWrapper = new InternalRowWrapper(context.dataSparkType());
        }

        @Override
        public void update(InternalRow meta, InternalRow id, InternalRow row) throws IOException {
            this.delete(meta, id);
            this.dataPartitionKey.partition((StructLike)this.internalRowDataWrapper.wrap(row));
            this.delegate.update((Object)row, this.dataSpec, (StructLike)this.dataPartitionKey);
        }

        @Override
        public void insert(InternalRow row) throws IOException {
            this.dataPartitionKey.partition((StructLike)this.internalRowDataWrapper.wrap(row));
            this.delegate.insert((Object)row, this.dataSpec, (StructLike)this.dataPartitionKey);
        }
    }

    private static class UnpartitionedDeltaWriter
    extends DeleteAndDataDeltaWriter {
        private final PartitionSpec dataSpec;

        UnpartitionedDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory dataFileFactory, OutputFileFactory deleteFileFactory, Context context) {
            super(table, writerFactory, dataFileFactory, deleteFileFactory, context);
            this.dataSpec = table.spec();
        }

        @Override
        public void update(InternalRow meta, InternalRow id, InternalRow row) throws IOException {
            this.delete(meta, id);
            this.delegate.update((Object)row, this.dataSpec, null);
        }

        @Override
        public void insert(InternalRow row) throws IOException {
            this.delegate.insert((Object)row, this.dataSpec, null);
        }
    }

    private static abstract class DeleteAndDataDeltaWriter
    extends BaseDeltaWriter {
        protected final PositionDeltaWriter<InternalRow> delegate;
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specs;
        private final InternalRowWrapper deletePartitionRowWrapper;
        private final Map<Integer, StructProjection> deletePartitionProjections;
        private final int specIdOrdinal;
        private final int partitionOrdinal;
        private final int fileOrdinal;
        private final int positionOrdinal;
        private boolean closed = false;

        DeleteAndDataDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory dataFileFactory, OutputFileFactory deleteFileFactory, Context context) {
            this.delegate = new BasePositionDeltaWriter(this.newInsertWriter(table, writerFactory, dataFileFactory, context), this.newUpdateWriter(table, writerFactory, dataFileFactory, context), this.newDeleteWriter(table, writerFactory, deleteFileFactory, context));
            this.io = table.io();
            this.specs = table.specs();
            Types.StructType partitionType = Partitioning.partitionType((Table)table);
            this.deletePartitionRowWrapper = this.initPartitionRowWrapper(partitionType);
            this.deletePartitionProjections = this.buildPartitionProjections(partitionType, this.specs);
            this.specIdOrdinal = context.metadataSparkType().fieldIndex(MetadataColumns.SPEC_ID.name());
            this.partitionOrdinal = context.metadataSparkType().fieldIndex("_partition");
            this.fileOrdinal = context.deleteSparkType().fieldIndex(MetadataColumns.FILE_PATH.name());
            this.positionOrdinal = context.deleteSparkType().fieldIndex(MetadataColumns.ROW_POSITION.name());
        }

        @Override
        public void delete(InternalRow meta, InternalRow id) throws IOException {
            int specId = meta.getInt(this.specIdOrdinal);
            PartitionSpec spec = this.specs.get(specId);
            InternalRow partition = meta.getStruct(this.partitionOrdinal, this.deletePartitionRowWrapper.size());
            StructProjection partitionProjection = this.deletePartitionProjections.get(specId);
            partitionProjection.wrap((StructLike)this.deletePartitionRowWrapper.wrap(partition));
            String file = id.getString(this.fileOrdinal);
            long position = id.getLong(this.positionOrdinal);
            this.delegate.delete((CharSequence)file, position, spec, (StructLike)partitionProjection);
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            WriteResult result = this.delegate.result();
            return new DeltaTaskCommit(result);
        }

        public void abort() throws IOException {
            this.close();
            WriteResult result = this.delegate.result();
            SparkPositionDeltaWrite.cleanFiles(this.io, Arrays.asList(result.dataFiles()));
            SparkPositionDeltaWrite.cleanFiles(this.io, Arrays.asList(result.deleteFiles()));
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.delegate.close();
                this.closed = true;
            }
        }

        private PartitioningWriter<InternalRow, DataWriteResult> newInsertWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory fileFactory, Context context) {
            long targetFileSize = context.targetDataFileSize();
            if (table.spec().isPartitioned() && context.fanoutWriterEnabled()) {
                return new FanoutDataWriter((FileWriterFactory)writerFactory, fileFactory, table.io(), targetFileSize);
            }
            return new ClusteredDataWriter((FileWriterFactory)writerFactory, fileFactory, table.io(), targetFileSize);
        }

        private PartitioningWriter<InternalRow, DataWriteResult> newUpdateWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory fileFactory, Context context) {
            long targetFileSize = context.targetDataFileSize();
            if (table.spec().isPartitioned()) {
                return new FanoutDataWriter((FileWriterFactory)writerFactory, fileFactory, table.io(), targetFileSize);
            }
            return new ClusteredDataWriter((FileWriterFactory)writerFactory, fileFactory, table.io(), targetFileSize);
        }

        private ClusteredPositionDeleteWriter<InternalRow> newDeleteWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory fileFactory, Context context) {
            long targetFileSize = context.targetDeleteFileSize();
            return new ClusteredPositionDeleteWriter((FileWriterFactory)writerFactory, fileFactory, table.io(), targetFileSize);
        }
    }

    private static class DeleteOnlyDeltaWriter
    extends BaseDeltaWriter {
        private final ClusteredPositionDeleteWriter<InternalRow> delegate;
        private final PositionDelete<InternalRow> positionDelete;
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specs;
        private final InternalRowWrapper partitionRowWrapper;
        private final Map<Integer, StructProjection> partitionProjections;
        private final int specIdOrdinal;
        private final int partitionOrdinal;
        private final int fileOrdinal;
        private final int positionOrdinal;
        private boolean closed = false;

        DeleteOnlyDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory deleteFileFactory, Context context) {
            this.delegate = new ClusteredPositionDeleteWriter((FileWriterFactory)writerFactory, deleteFileFactory, table.io(), context.targetDeleteFileSize());
            this.positionDelete = PositionDelete.create();
            this.io = table.io();
            this.specs = table.specs();
            Types.StructType partitionType = Partitioning.partitionType((Table)table);
            this.partitionRowWrapper = this.initPartitionRowWrapper(partitionType);
            this.partitionProjections = this.buildPartitionProjections(partitionType, this.specs);
            this.specIdOrdinal = context.metadataSparkType().fieldIndex(MetadataColumns.SPEC_ID.name());
            this.partitionOrdinal = context.metadataSparkType().fieldIndex("_partition");
            this.fileOrdinal = context.deleteSparkType().fieldIndex(MetadataColumns.FILE_PATH.name());
            this.positionOrdinal = context.deleteSparkType().fieldIndex(MetadataColumns.ROW_POSITION.name());
        }

        @Override
        public void delete(InternalRow metadata, InternalRow id) throws IOException {
            int specId = metadata.getInt(this.specIdOrdinal);
            PartitionSpec spec = this.specs.get(specId);
            InternalRow partition = metadata.getStruct(this.partitionOrdinal, this.partitionRowWrapper.size());
            StructProjection partitionProjection = this.partitionProjections.get(specId);
            partitionProjection.wrap((StructLike)this.partitionRowWrapper.wrap(partition));
            String file = id.getString(this.fileOrdinal);
            long position = id.getLong(this.positionOrdinal);
            this.positionDelete.set((CharSequence)file, position, null);
            this.delegate.write(this.positionDelete, spec, (StructLike)partitionProjection);
        }

        @Override
        public void update(InternalRow metadata, InternalRow id, InternalRow row) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement update");
        }

        @Override
        public void insert(InternalRow row) throws IOException {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement insert");
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            DeleteWriteResult result = (DeleteWriteResult)this.delegate.result();
            return new DeltaTaskCommit(result);
        }

        public void abort() throws IOException {
            this.close();
            DeleteWriteResult result = (DeleteWriteResult)this.delegate.result();
            SparkPositionDeltaWrite.cleanFiles(this.io, result.deleteFiles());
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.delegate.close();
                this.closed = true;
            }
        }
    }

    private static abstract class BaseDeltaWriter
    implements DeltaWriter<InternalRow> {
        private BaseDeltaWriter() {
        }

        protected InternalRowWrapper initPartitionRowWrapper(Types.StructType partitionType) {
            StructType sparkPartitionType = (StructType)SparkSchemaUtil.convert((Type)partitionType);
            return new InternalRowWrapper(sparkPartitionType);
        }

        protected Map<Integer, StructProjection> buildPartitionProjections(Types.StructType partitionType, Map<Integer, PartitionSpec> specs) {
            HashMap partitionProjections = Maps.newHashMap();
            specs.forEach((specID, spec) -> partitionProjections.put(specID, StructProjection.create((Types.StructType)partitionType, (Types.StructType)spec.partitionType())));
            return partitionProjections;
        }
    }

    private static class PositionDeltaWriteFactory
    implements DeltaWriterFactory {
        private final Broadcast<Table> tableBroadcast;
        private final RowLevelOperation.Command command;
        private final Context context;

        PositionDeltaWriteFactory(Broadcast<Table> tableBroadcast, RowLevelOperation.Command command, Context context) {
            this.tableBroadcast = tableBroadcast;
            this.command = command;
            this.context = context;
        }

        @Override
        public DeltaWriter<InternalRow> createWriter(int partitionId, long taskId) {
            Table table = (Table)this.tableBroadcast.value();
            OutputFileFactory dataFileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(this.context.dataFileFormat()).build();
            OutputFileFactory deleteFileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(this.context.deleteFileFormat()).build();
            SparkFileWriterFactory writerFactory = SparkFileWriterFactory.builderFor(table).dataFileFormat(this.context.dataFileFormat()).dataSchema(this.context.dataSchema()).dataSparkType(this.context.dataSparkType()).deleteFileFormat(this.context.deleteFileFormat()).positionDeleteSparkType(this.context.deleteSparkType()).build();
            if (this.command == RowLevelOperation.Command.DELETE) {
                return new DeleteOnlyDeltaWriter(table, writerFactory, deleteFileFactory, this.context);
            }
            if (table.spec().isUnpartitioned()) {
                return new UnpartitionedDeltaWriter(table, writerFactory, dataFileFactory, deleteFileFactory, this.context);
            }
            return new PartitionedDeltaWriter(table, writerFactory, dataFileFactory, deleteFileFactory, this.context);
        }
    }

    public static class DeltaTaskCommit
    implements WriterCommitMessage {
        private final DataFile[] dataFiles;
        private final DeleteFile[] deleteFiles;
        private final CharSequence[] referencedDataFiles;

        DeltaTaskCommit(WriteResult result) {
            this.dataFiles = result.dataFiles();
            this.deleteFiles = result.deleteFiles();
            this.referencedDataFiles = result.referencedDataFiles();
        }

        DeltaTaskCommit(DeleteWriteResult result) {
            this.dataFiles = new DataFile[0];
            this.deleteFiles = result.deleteFiles().toArray(new DeleteFile[0]);
            this.referencedDataFiles = (CharSequence[])result.referencedDataFiles().toArray((Object[])new CharSequence[0]);
        }

        DataFile[] dataFiles() {
            return this.dataFiles;
        }

        DeleteFile[] deleteFiles() {
            return this.deleteFiles;
        }

        CharSequence[] referencedDataFiles() {
            return this.referencedDataFiles;
        }
    }

    private class PositionDeltaBatchWrite
    implements DeltaBatchWrite {
        private PositionDeltaBatchWrite() {
        }

        @Override
        public DeltaWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            Broadcast tableBroadcast = SparkPositionDeltaWrite.this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(SparkPositionDeltaWrite.this.table));
            return new PositionDeltaWriteFactory((Broadcast<Table>)tableBroadcast, SparkPositionDeltaWrite.this.command, SparkPositionDeltaWrite.this.context);
        }

        public void commit(WriterCommitMessage[] messages) {
            RowDelta rowDelta = SparkPositionDeltaWrite.this.table.newRowDelta();
            CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
            int addedDataFilesCount = 0;
            int addedDeleteFilesCount = 0;
            for (WriterCommitMessage message : messages) {
                DeltaTaskCommit taskCommit = (DeltaTaskCommit)message;
                for (DataFile dataFile : taskCommit.dataFiles()) {
                    rowDelta.addRows(dataFile);
                    ++addedDataFilesCount;
                }
                for (DataFile dataFile : taskCommit.deleteFiles()) {
                    rowDelta.addDeletes((DeleteFile)dataFile);
                    ++addedDeleteFilesCount;
                }
                referencedDataFiles.addAll(Arrays.asList(taskCommit.referencedDataFiles()));
            }
            if (SparkPositionDeltaWrite.this.scan != null) {
                Expression conflictDetectionFilter = this.conflictDetectionFilter(SparkPositionDeltaWrite.this.scan);
                rowDelta.conflictDetectionFilter(conflictDetectionFilter);
                rowDelta.validateDataFilesExist((Iterable)referencedDataFiles);
                if (SparkPositionDeltaWrite.this.scan.snapshotId() != null) {
                    rowDelta.validateFromSnapshot(SparkPositionDeltaWrite.this.scan.snapshotId().longValue());
                }
                if (SparkPositionDeltaWrite.this.command == RowLevelOperation.Command.UPDATE || SparkPositionDeltaWrite.this.command == RowLevelOperation.Command.MERGE) {
                    rowDelta.validateDeletedFiles();
                    rowDelta.validateNoConflictingDeleteFiles();
                }
                if (SparkPositionDeltaWrite.this.isolationLevel == IsolationLevel.SERIALIZABLE) {
                    rowDelta.validateNoConflictingDataFiles();
                }
                String commitMsg = String.format("position delta with %d data files and %d delete files (scanSnapshotId: %d, conflictDetectionFilter: %s, isolationLevel: %s)", addedDataFilesCount, addedDeleteFilesCount, SparkPositionDeltaWrite.this.scan.snapshotId(), conflictDetectionFilter, SparkPositionDeltaWrite.this.isolationLevel);
                this.commitOperation((SnapshotUpdate<?>)rowDelta, commitMsg);
            } else {
                String commitMsg = String.format("position delta with %d data files and %d delete files (no validation required)", addedDataFilesCount, addedDeleteFilesCount);
                this.commitOperation((SnapshotUpdate<?>)rowDelta, commitMsg);
            }
        }

        private Expression conflictDetectionFilter(SparkBatchQueryScan queryScan) {
            True filter = Expressions.alwaysTrue();
            for (Expression expr : queryScan.filterExpressions()) {
                filter = Expressions.and((Expression)filter, (Expression)expr);
            }
            return filter;
        }

        public void abort(WriterCommitMessage[] messages) {
            if (!SparkPositionDeltaWrite.this.cleanupOnAbort) {
                return;
            }
            for (WriterCommitMessage message : messages) {
                if (message == null) continue;
                DeltaTaskCommit taskCommit = (DeltaTaskCommit)message;
                SparkPositionDeltaWrite.cleanFiles(SparkPositionDeltaWrite.this.table.io(), Arrays.asList(taskCommit.dataFiles()));
                SparkPositionDeltaWrite.cleanFiles(SparkPositionDeltaWrite.this.table.io(), Arrays.asList(taskCommit.deleteFiles()));
            }
        }

        private void commitOperation(SnapshotUpdate<?> operation, String description) {
            LOG.info("Committing {} to table {}", (Object)description, (Object)SparkPositionDeltaWrite.this.table);
            if (SparkPositionDeltaWrite.this.applicationId != null) {
                operation.set("spark.app.id", SparkPositionDeltaWrite.this.applicationId);
            }
            SparkPositionDeltaWrite.this.extraSnapshotMetadata.forEach((arg_0, arg_1) -> operation.set(arg_0, arg_1));
            if (!CommitMetadata.commitProperties().isEmpty()) {
                CommitMetadata.commitProperties().forEach((arg_0, arg_1) -> operation.set(arg_0, arg_1));
            }
            if (SparkPositionDeltaWrite.this.wapEnabled && SparkPositionDeltaWrite.this.wapId != null) {
                operation.set("wap.id", SparkPositionDeltaWrite.this.wapId);
                operation.stageOnly();
            }
            try {
                long start = System.currentTimeMillis();
                operation.commit();
                long duration = System.currentTimeMillis() - start;
                LOG.info("Committed in {} ms", (Object)duration);
            }
            catch (CommitStateUnknownException commitStateUnknownException) {
                SparkPositionDeltaWrite.this.cleanupOnAbort = false;
                throw commitStateUnknownException;
            }
        }
    }
}

