/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkTestHelperBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class SparkTestBase
extends SparkTestHelperBase {
    protected static TestHiveMetastore metastore = null;
    protected static HiveConf hiveConf = null;
    protected static SparkSession spark = null;
    protected static HiveCatalog catalog = null;

    @BeforeClass
    public static void startMetastoreAndSpark() {
        metastore = new TestHiveMetastore();
        metastore.start();
        hiveConf = metastore.hiveConf();
        spark = SparkSession.builder().master("local[2]").config(SQLConf.PARTITION_OVERWRITE_MODE().key(), "dynamic").config("spark.hadoop." + HiveConf.ConfVars.METASTOREURIS.varname, hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)).enableHiveSupport().getOrCreate();
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
        try {
            catalog.createNamespace(Namespace.of((String[])new String[]{"default"}));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void stopMetastoreAndSpark() throws Exception {
        catalog = null;
        if (metastore != null) {
            metastore.stop();
            metastore = null;
        }
        if (spark != null) {
            spark.stop();
            spark = null;
        }
    }

    protected long waitUntilAfter(long timestampMillis) {
        long current = System.currentTimeMillis();
        while (current <= timestampMillis) {
            current = System.currentTimeMillis();
        }
        return current;
    }

    protected List<Object[]> sql(String query, Object ... args) {
        List rows = spark.sql(String.format(query, args)).collectAsList();
        if (rows.size() < 1) {
            return ImmutableList.of();
        }
        return this.rowsToJava(rows);
    }

    protected Object scalarSql(String query, Object ... args) {
        List<Object[]> rows = this.sql(query, args);
        Assert.assertEquals((String)"Scalar SQL should return one row", (long)1L, (long)rows.size());
        Object[] row = (Object[])Iterables.getOnlyElement(rows);
        Assert.assertEquals((String)"Scalar SQL should return one value", (long)1L, (long)row.length);
        return row[0];
    }

    protected Object[] row(Object ... values) {
        return values;
    }

    protected static String dbPath(String dbName) {
        return metastore.getDatabasePath(dbName);
    }

    protected void withUnavailableFiles(Iterable<? extends ContentFile<?>> files, Action action) {
        Iterable fileLocations = Iterables.transform(files, file -> file.path().toString());
        this.withUnavailableLocations(fileLocations, action);
    }

    private void move(String location, String newLocation) {
        Path path = Paths.get(URI.create(location));
        Path tempPath = Paths.get(URI.create(newLocation));
        try {
            Files.move(path, tempPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to move: " + location, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withUnavailableLocations(Iterable<String> locations, Action action) {
        for (String location : locations) {
            this.move(location, location + "_temp");
        }
        try {
            action.invoke();
        }
        finally {
            for (String location : locations) {
                this.move(location + "_temp", location);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withSQLConf(Map<String, String> conf, Action action) {
        SQLConf sqlConf = SQLConf.get();
        HashMap currentConfValues = Maps.newHashMap();
        conf.keySet().forEach(confKey -> {
            if (sqlConf.contains(confKey)) {
                String currentConfValue = sqlConf.getConfString(confKey);
                currentConfValues.put(confKey, currentConfValue);
            }
        });
        conf.forEach((confKey, confValue) -> {
            if (SQLConf.isStaticConfigKey((String)confKey)) {
                throw new RuntimeException("Cannot modify the value of a static config: " + confKey);
            }
            sqlConf.setConfString(confKey, confValue);
        });
        try {
            action.invoke();
        }
        finally {
            conf.forEach((confKey, confValue) -> {
                if (currentConfValues.containsKey(confKey)) {
                    sqlConf.setConfString(confKey, (String)currentConfValues.get(confKey));
                } else {
                    sqlConf.unsetConf(confKey);
                }
            });
        }
    }

    protected Dataset<Row> jsonToDF(String schema, String ... records) {
        Dataset jsonDF = spark.createDataset((List)ImmutableList.copyOf((Object[])records), Encoders.STRING());
        return spark.read().schema(schema).json(jsonDF);
    }

    @FunctionalInterface
    protected static interface Action {
        public void invoke();
    }
}

