/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkTestBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class SparkTestBaseWithCatalog
extends SparkTestBase {
    private static File warehouse = null;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    protected final String catalogName;
    protected final Catalog validationCatalog;
    protected final SupportsNamespaces validationNamespaceCatalog;
    protected final TableIdentifier tableIdent = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"default"}), (String)"table");
    protected final String tableName;

    @BeforeClass
    public static void createWarehouse() throws IOException {
        warehouse = File.createTempFile("warehouse", null);
        Assert.assertTrue((boolean)warehouse.delete());
    }

    @AfterClass
    public static void dropWarehouse() throws IOException {
        if (warehouse != null && warehouse.exists()) {
            Path warehousePath = new Path(warehouse.getAbsolutePath());
            FileSystem fs = warehousePath.getFileSystem((Configuration)hiveConf);
            Assert.assertTrue((String)("Failed to delete " + warehousePath), (boolean)fs.delete(warehousePath, true));
        }
    }

    public SparkTestBaseWithCatalog() {
        this(SparkCatalogConfig.HADOOP);
    }

    public SparkTestBaseWithCatalog(SparkCatalogConfig config) {
        this(config.catalogName(), config.implementation(), config.properties());
    }

    public SparkTestBaseWithCatalog(String catalogName, String implementation, Map<String, String> config) {
        this.catalogName = catalogName;
        this.validationCatalog = catalogName.equals("testhadoop") ? new HadoopCatalog(spark.sessionState().newHadoopConf(), "file:" + warehouse) : catalog;
        this.validationNamespaceCatalog = (SupportsNamespaces)this.validationCatalog;
        spark.conf().set("spark.sql.catalog." + catalogName, implementation);
        config.forEach((key, value) -> spark.conf().set("spark.sql.catalog." + catalogName + "." + key, value));
        if (config.get("type").equalsIgnoreCase("hadoop")) {
            spark.conf().set("spark.sql.catalog." + catalogName + ".warehouse", "file:" + warehouse);
        }
        this.tableName = (catalogName.equals("spark_catalog") ? "" : catalogName + ".") + "default.table";
        this.sql("CREATE NAMESPACE IF NOT EXISTS default", new Object[0]);
    }

    protected String tableName(String name) {
        return (this.catalogName.equals("spark_catalog") ? "" : this.catalogName + ".") + "default." + name;
    }
}

