/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestSparkSchemaUtil {
    private static final Schema TEST_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final Schema TEST_SCHEMA_WITH_METADATA_COLS = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION});

    @Test
    public void testEstimateSizeMaxValue() throws IOException {
        Assert.assertEquals((String)"estimateSize returns Long max value", (long)Long.MAX_VALUE, (long)SparkSchemaUtil.estimateSize(null, (long)Long.MAX_VALUE));
    }

    @Test
    public void testEstimateSizeWithOverflow() throws IOException {
        long tableSize = SparkSchemaUtil.estimateSize((StructType)SparkSchemaUtil.convert((Schema)TEST_SCHEMA), (long)0x7FFFFFFFFFFFFFFEL);
        Assert.assertEquals((String)"estimateSize handles overflow", (long)Long.MAX_VALUE, (long)tableSize);
    }

    @Test
    public void testEstimateSize() throws IOException {
        long tableSize = SparkSchemaUtil.estimateSize((StructType)SparkSchemaUtil.convert((Schema)TEST_SCHEMA), (long)1L);
        Assert.assertEquals((String)"estimateSize matches with expected approximation", (long)24L, (long)tableSize);
    }

    @Test
    public void testSchemaConversionWithMetaDataColumnSchema() {
        StructType structType = SparkSchemaUtil.convert((Schema)TEST_SCHEMA_WITH_METADATA_COLS);
        List attrRefs = JavaConverters.seqAsJavaList((Seq)structType.toAttributes());
        for (AttributeReference attrRef : attrRefs) {
            if (MetadataColumns.isMetadataColumn((String)attrRef.name())) {
                Assert.assertTrue((String)"metadata columns should have __metadata_col in attribute metadata", (attrRef.metadata().contains("__metadata_col") && attrRef.metadata().getBoolean("__metadata_col") ? 1 : 0) != 0);
                continue;
            }
            Assert.assertFalse((String)"non metadata columns should not have __metadata_col in attribute metadata", (boolean)attrRef.metadata().contains("__metadata_col"));
        }
    }
}

