/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.spark.SparkTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSparkSessionCatalog
extends SparkTestBase {
    private final String envHmsUriKey;
    private final String catalogHmsUriKey = "spark.sql.catalog.spark_catalog.uri";
    private final String hmsUri;

    public TestSparkSessionCatalog() {
        this.envHmsUriKey = "spark.hadoop." + HiveConf.ConfVars.METASTOREURIS.varname;
        this.catalogHmsUriKey = "spark.sql.catalog.spark_catalog.uri";
        this.hmsUri = hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    @BeforeClass
    public static void setUpCatalog() {
        spark.conf().set("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.SparkSessionCatalog");
        spark.conf().set("spark.sql.catalog.spark_catalog.type", "hive");
    }

    @Before
    public void setupHmsUri() {
        spark.sessionState().catalogManager().reset();
        spark.conf().set(this.envHmsUriKey, this.hmsUri);
        spark.conf().set("spark.sql.catalog.spark_catalog.uri", this.hmsUri);
    }

    @Test
    public void testValidateHmsUri() {
        Assert.assertTrue((boolean)spark.sessionState().catalogManager().v2SessionCatalog().defaultNamespace()[0].equals("default"));
        spark.sessionState().catalogManager().reset();
        String catalogHmsUri = "RandomString";
        spark.conf().set(this.envHmsUriKey, this.hmsUri);
        spark.conf().set("spark.sql.catalog.spark_catalog.uri", catalogHmsUri);
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> spark.sessionState().catalogManager().v2SessionCatalog());
        String errorMessage = String.format("Inconsistent Hive metastore URIs: %s (Spark session) != %s (spark_catalog)", this.hmsUri, catalogHmsUri);
        Assert.assertEquals((Object)errorMessage, (Object)exception.getMessage());
        spark.sessionState().catalogManager().reset();
        spark.conf().set("spark.sql.catalog.spark_catalog.uri", this.hmsUri);
        spark.conf().unset(this.envHmsUriKey);
        Assert.assertTrue((boolean)spark.sessionState().catalogManager().v2SessionCatalog().defaultNamespace()[0].equals("default"));
        spark.sessionState().catalogManager().reset();
        spark.conf().set(this.envHmsUriKey, this.hmsUri);
        spark.conf().unset("spark.sql.catalog.spark_catalog.uri");
        Assert.assertTrue((boolean)spark.sessionState().catalogManager().v2SessionCatalog().defaultNamespace()[0].equals("default"));
    }

    @Test
    public void testLoadFunction() {
        String functionClass = "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper";
        spark.sql(String.format("CREATE FUNCTION perm_upper AS '%s'", functionClass));
        Assert.assertEquals((String)"Load permanent UDF in Hive", (Object)"XYZ", (Object)this.scalarSql("SELECT perm_upper('xyz')", new Object[0]));
        spark.sql(String.format("CREATE TEMPORARY FUNCTION temp_upper AS '%s'", functionClass));
        Assert.assertEquals((String)"Load temporary UDF in Hive", (Object)"XYZ", (Object)this.scalarSql("SELECT temp_upper('xyz')", new Object[0]));
    }
}

