/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.SparkWriteConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkWriteConf
extends SparkTestBaseWithCatalog {
    @Before
    public void before() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
    }

    @After
    public void after() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testSparkWriteConfDistributionDefault() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        Assert.assertEquals((Object)DistributionMode.HASH, (Object)writeConf.distributionMode());
        Assert.assertEquals((Object)DistributionMode.HASH, (Object)writeConf.deleteDistributionMode());
        Assert.assertEquals((Object)DistributionMode.HASH, (Object)writeConf.updateDistributionMode());
        Assert.assertEquals((Object)DistributionMode.HASH, (Object)writeConf.copyOnWriteMergeDistributionMode());
        Assert.assertEquals((Object)DistributionMode.HASH, (Object)writeConf.positionDeltaMergeDistributionMode());
    }

    @Test
    public void testSparkWriteConfDistributionModeWithWriteOption() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.distributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.deleteDistributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.updateDistributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.copyOnWriteMergeDistributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.positionDeltaMergeDistributionMode());
    }

    @Test
    public void testSparkWriteConfDistributionModeWithSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.NONE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.distributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.deleteDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.updateDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.copyOnWriteMergeDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.positionDeltaMergeDistributionMode());
        });
    }

    @Test
    public void testSparkWriteConfDistributionModeWithTableProperties() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "none").set("write.delete.distribution-mode", "none").set("write.update.distribution-mode", "none").set("write.merge.distribution-mode", "none").commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.distributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.deleteDistributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.updateDistributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.copyOnWriteMergeDistributionMode());
        Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.positionDeltaMergeDistributionMode());
    }

    @Test
    public void testSparkWriteConfDistributionModeWithTblPropAndSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.NONE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            table.updateProperties().set("write.distribution-mode", "range").set("write.delete.distribution-mode", "range").set("write.update.distribution-mode", "range").set("write.merge.distribution-mode", "range").commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.distributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.deleteDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.updateDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.copyOnWriteMergeDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.positionDeltaMergeDistributionMode());
        });
    }

    @Test
    public void testSparkWriteConfDistributionModeWithWriteOptionAndSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.RANGE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.distributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.deleteDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.updateDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.copyOnWriteMergeDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.positionDeltaMergeDistributionMode());
        });
    }

    @Test
    public void testSparkWriteConfDistributionModeWithEverything() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.RANGE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
            table.updateProperties().set("write.distribution-mode", "hash").set("write.delete.distribution-mode", "hash").set("write.update.distribution-mode", "hash").set("write.merge.distribution-mode", "hash").commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.distributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.deleteDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.updateDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.copyOnWriteMergeDistributionMode());
            Assert.assertEquals((Object)DistributionMode.NONE, (Object)writeConf.positionDeltaMergeDistributionMode());
        });
    }
}

