/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.MigrateTable;
import org.apache.iceberg.actions.SnapshotTable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestCreateActions
extends SparkCatalogTestBase {
    private static final String CREATE_PARTITIONED_PARQUET = "CREATE TABLE %s (id INT, data STRING) using parquet PARTITIONED BY (id) LOCATION '%s'";
    private static final String CREATE_PARQUET = "CREATE TABLE %s (id INT, data STRING) using parquet LOCATION '%s'";
    private static final String CREATE_HIVE_EXTERNAL_PARQUET = "CREATE EXTERNAL TABLE %s (data STRING) PARTITIONED BY (id INT) STORED AS parquet LOCATION '%s'";
    private static final String CREATE_HIVE_PARQUET = "CREATE TABLE %s (data STRING) PARTITIONED BY (id INT) STORED AS parquet";
    private static final String NAMESPACE = "default";
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private String baseTableName = "baseTable";
    private File tableDir;
    private String tableLocation;
    private final String type;
    private final TableCatalog catalog;

    @Parameterized.Parameters(name="Catalog Name {0} - Options {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)NAMESPACE, (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false")}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"default-namespace", (Object)NAMESPACE, (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false")}, {"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)NAMESPACE)}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"default-namespace", (Object)NAMESPACE)}};
    }

    public TestCreateActions(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        this.catalog = (TableCatalog)spark.sessionState().catalogManager().catalog(catalogName);
        this.type = config.get("type");
    }

    @Before
    public void before() {
        try {
            this.tableDir = this.temp.newFolder();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tableLocation = this.tableDir.toURI().toString();
        spark.conf().set("hive.exec.dynamic.partition", "true");
        spark.conf().set("hive.exec.dynamic.partition.mode", "nonstrict");
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", false);
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", false);
        spark.sql(String.format("DROP TABLE IF EXISTS %s", this.baseTableName));
        ArrayList expected = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c")});
        Dataset df = spark.createDataFrame((List)expected, SimpleRecord.class);
        df.select("id", new String[]{"data"}).orderBy("data", new String[0]).write().mode("append").option("path", this.tableLocation).saveAsTable(this.baseTableName);
    }

    @After
    public void after() throws IOException {
        spark.sql(String.format("DROP TABLE IF EXISTS %s", this.baseTableName));
    }

    @Test
    public void testMigratePartitioned() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_migrate_partitioned_table");
        this.createSourceTable(CREATE_PARTITIONED_PARQUET, source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @Test
    public void testPartitionedTableWithUnRecoveredPartitions() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_unrecovered_partitions");
        File location = this.temp.newFolder();
        this.sql(CREATE_PARTITIONED_PARQUET, source, location);
        spark.range(5L).selectExpr(new String[]{"id", "cast(id as STRING) as data"}).write().partitionBy(new String[]{"id"}).mode(SaveMode.Overwrite).parquet(location.toURI().toString());
        this.sql("ALTER TABLE %s ADD PARTITION(id=0)", source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @Test
    public void testPartitionedTableWithCustomPartitions() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_custom_parts");
        File tblLocation = this.temp.newFolder();
        File partitionDataLoc = this.temp.newFolder();
        spark.sql(String.format(CREATE_PARTITIONED_PARQUET, source, tblLocation));
        spark.range(10L).selectExpr(new String[]{"cast(id as STRING) as data"}).write().mode(SaveMode.Overwrite).parquet(partitionDataLoc.toURI().toString());
        this.sql("ALTER TABLE %s ADD PARTITION(id=0) LOCATION '%s'", source, partitionDataLoc.toURI().toString());
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @Test
    public void testAddColumnOnMigratedTableAtEnd() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_add_column_migrated_table");
        this.createSourceTable(CREATE_PARQUET, source);
        List<Object[]> expected1 = this.sql("select *, null from %s order by id", source);
        List<Object[]> expected2 = this.sql("select *, null, null from %s order by id", source);
        SparkActions.get().migrateTable(source).execute();
        SparkTable sparkTable = this.loadTable(dest);
        Table table = sparkTable.table();
        Schema beforeSchema = table.schema();
        String newCol1 = "newCol1";
        sparkTable.table().updateSchema().addColumn(newCol1, (Type)Types.IntegerType.get()).commit();
        Schema afterSchema = table.schema();
        Assert.assertNull((Object)beforeSchema.findField(newCol1));
        Assert.assertNotNull((Object)afterSchema.findField(newCol1));
        List<Object[]> results1 = this.sql("select * from %s order by id", dest);
        Assert.assertTrue((results1.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", results1, expected1);
        String newCol2 = "newCol2";
        this.sql("ALTER TABLE %s ADD COLUMN %s INT", dest, newCol2);
        StructType schema = spark.table(dest).schema();
        Assert.assertTrue((boolean)Arrays.asList(schema.fieldNames()).contains(newCol2));
        List<Object[]> results2 = this.sql("select * from %s order by id", dest);
        Assert.assertTrue((results2.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", results2, expected2);
    }

    @Test
    public void testAddColumnOnMigratedTableAtMiddle() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_add_column_migrated_table_middle");
        this.createSourceTable(CREATE_PARQUET, source);
        SparkActions.get().migrateTable(source).execute();
        SparkTable sparkTable = this.loadTable(dest);
        Table table = sparkTable.table();
        List<Object[]> expected = this.sql("select id, null, data from %s order by id", source);
        Schema beforeSchema = table.schema();
        String newCol1 = "newCol";
        sparkTable.table().updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).moveAfter(newCol1, "id").commit();
        Schema afterSchema = table.schema();
        Assert.assertNull((Object)beforeSchema.findField(newCol1));
        Assert.assertNotNull((Object)afterSchema.findField(newCol1));
        List<Object[]> results = this.sql("select * from %s order by id", dest);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", results, expected);
    }

    @Test
    public void removeColumnsAtEnd() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_remove_column_migrated_table");
        String colName1 = "newCol1";
        String colName2 = "newCol2";
        File location = this.temp.newFolder();
        spark.range(10L).selectExpr(new String[]{"cast(id as INT)", "CAST(id as INT) " + colName1, "CAST(id as INT) " + colName2}).write().mode(SaveMode.Overwrite).saveAsTable(dest);
        List<Object[]> expected1 = this.sql("select id, %s from %s order by id", colName1, source);
        List<Object[]> expected2 = this.sql("select id from %s order by id", source);
        SparkActions.get().migrateTable(source).execute();
        SparkTable sparkTable = this.loadTable(dest);
        Table table = sparkTable.table();
        Schema beforeSchema = table.schema();
        sparkTable.table().updateSchema().deleteColumn(colName1).commit();
        Schema afterSchema = table.schema();
        Assert.assertNotNull((Object)beforeSchema.findField(colName1));
        Assert.assertNull((Object)afterSchema.findField(colName1));
        List<Object[]> results1 = this.sql("select * from %s order by id", dest);
        Assert.assertTrue((results1.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected1, results1);
        this.sql("ALTER TABLE %s DROP COLUMN %s", dest, colName2);
        StructType schema = spark.table(dest).schema();
        Assert.assertFalse((boolean)Arrays.asList(schema.fieldNames()).contains(colName2));
        List<Object[]> results2 = this.sql("select * from %s order by id", dest);
        Assert.assertTrue((results2.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected2, results2);
    }

    @Test
    public void removeColumnFromMiddle() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_remove_column_migrated_table_from_middle");
        String dropColumnName = "col1";
        spark.range(10L).selectExpr(new String[]{"cast(id as INT)", "CAST(id as INT) as " + dropColumnName, "CAST(id as INT) as col2"}).write().mode(SaveMode.Overwrite).saveAsTable(dest);
        List<Object[]> expected = this.sql("select id, col2 from %s order by id", source);
        SparkActions.get().migrateTable(source).execute();
        this.sql("ALTER TABLE %s DROP COLUMN %s", dest, "col1");
        StructType schema = spark.table(dest).schema();
        Assert.assertFalse((boolean)Arrays.asList(schema.fieldNames()).contains(dropColumnName));
        List<Object[]> results = this.sql("select * from %s order by id", dest);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected, results);
    }

    @Test
    public void testMigrateUnpartitioned() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String dest = source = this.sourceName("test_migrate_unpartitioned_table");
        this.createSourceTable(CREATE_PARQUET, source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @Test
    public void testSnapshotPartitioned() throws Exception {
        Assume.assumeTrue((String)"Cannot snapshot with arbitrary location in a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        File location = this.temp.newFolder();
        String source = this.sourceName("test_snapshot_partitioned_table");
        String dest = this.destName("iceberg_snapshot_partitioned");
        this.createSourceTable(CREATE_PARTITIONED_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @Test
    public void testSnapshotUnpartitioned() throws Exception {
        Assume.assumeTrue((String)"Cannot snapshot with arbitrary location in a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        File location = this.temp.newFolder();
        String source = this.sourceName("test_snapshot_unpartitioned_table");
        String dest = this.destName("iceberg_snapshot_unpartitioned");
        this.createSourceTable(CREATE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @Test
    public void testSnapshotHiveTable() throws Exception {
        Assume.assumeTrue((String)"Cannot snapshot with arbitrary location in a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        File location = this.temp.newFolder();
        String source = this.sourceName("snapshot_hive_table");
        String dest = this.destName("iceberg_snapshot_hive_table");
        this.createSourceTable(CREATE_HIVE_EXTERNAL_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @Test
    public void testMigrateHiveTable() throws Exception {
        String source;
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        String dest = source = this.sourceName("migrate_hive_table");
        this.createSourceTable(CREATE_HIVE_EXTERNAL_PARQUET, source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @Test
    public void testSnapshotManagedHiveTable() throws Exception {
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        File location = this.temp.newFolder();
        String source = this.sourceName("snapshot_managed_hive_table");
        String dest = this.destName("iceberg_snapshot_managed_hive_table");
        this.createSourceTable(CREATE_HIVE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @Test
    public void testMigrateManagedHiveTable() throws Exception {
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        File location = this.temp.newFolder();
        String source = this.sourceName("migrate_managed_hive_table");
        String dest = this.destName("iceberg_migrate_managed_hive_table");
        this.createSourceTable(CREATE_HIVE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
    }

    @Test
    public void testProperties() throws Exception {
        String source = this.sourceName("test_properties_table");
        String dest = this.destName("iceberg_properties");
        HashMap props = Maps.newHashMap();
        props.put("city", "New Orleans");
        props.put("note", "Jazz");
        this.createSourceTable(CREATE_PARQUET, source);
        for (Map.Entry keyValue : props.entrySet()) {
            spark.sql(String.format("ALTER TABLE %s SET TBLPROPERTIES (\"%s\" = \"%s\")", source, keyValue.getKey(), keyValue.getValue()));
        }
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableProperty("dogs", "sundance"), source, dest);
        SparkTable table = this.loadTable(dest);
        HashMap expectedProps = Maps.newHashMap();
        expectedProps.putAll(props);
        expectedProps.put("dogs", "sundance");
        for (Map.Entry entry : expectedProps.entrySet()) {
            Assert.assertTrue((String)("Created table missing property " + (String)entry.getKey()), (boolean)table.properties().containsKey(entry.getKey()));
            Assert.assertEquals((String)"Property value is not the expected value", entry.getValue(), table.properties().get(entry.getKey()));
        }
    }

    @Test
    public void testSparkTableReservedProperties() throws Exception {
        String[] keys;
        String destTableName = "iceberg_reserved_properties";
        String source = this.sourceName("test_reserved_properties_table");
        String dest = this.destName(destTableName);
        this.createSourceTable(CREATE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest), source, dest);
        SparkTable table = this.loadTable(dest);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.table().replaceSortOrder().asc("id")).desc("data")).commit();
        for (String entry : keys = new String[]{"provider", "format", "current-snapshot-id", "location", "sort-order"}) {
            Assert.assertTrue((String)("Created table missing reserved property " + entry), (boolean)table.properties().containsKey(entry));
        }
        Assert.assertEquals((String)"Unexpected provider", (Object)"iceberg", table.properties().get("provider"));
        Assert.assertEquals((String)"Unexpected format", (Object)"iceberg/parquet", table.properties().get("format"));
        Assert.assertNotEquals((String)"No current-snapshot-id found", (Object)"none", table.properties().get("current-snapshot-id"));
        Assert.assertTrue((String)"Location isn't correct", (boolean)((String)table.properties().get("location")).endsWith(destTableName));
        Assert.assertEquals((String)"Unexpected format-version", (Object)"1", table.properties().get("format-version"));
        table.table().updateProperties().set("format-version", "2").commit();
        Assert.assertEquals((String)"Unexpected format-version", (Object)"2", table.properties().get("format-version"));
        Assert.assertEquals((String)"Sort-order isn't correct", (Object)"id ASC NULLS FIRST, data DESC NULLS LAST", table.properties().get("sort-order"));
        Assert.assertNull((String)"Identifier fields should be null", table.properties().get("identifier-fields"));
        table.table().updateSchema().allowIncompatibleChanges().requireColumn("id").setIdentifierFields(new String[]{"id"}).commit();
        Assert.assertEquals((String)"Identifier fields aren't correct", (Object)"[id]", table.properties().get("identifier-fields"));
    }

    @Test
    public void testSnapshotDefaultLocation() throws Exception {
        String source = this.sourceName("test_snapshot_default");
        String dest = this.destName("iceberg_snapshot_default");
        this.createSourceTable(CREATE_PARTITIONED_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @Test
    public void schemaEvolutionTestWithSparkAPI() throws Exception {
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        File location = this.temp.newFolder();
        String tblName = this.sourceName("schema_evolution_test");
        spark.range(0L, 5L).selectExpr(new String[]{"CAST(id as INT) as col0", "CAST(id AS FLOAT) col2", "CAST(id AS LONG) col3"}).write().mode(SaveMode.Append).parquet(location.toURI().toString());
        Dataset rowDataset = spark.range(6L, 10L).selectExpr(new String[]{"CAST(id as INT) as col0", "CAST(id AS STRING) col1", "CAST(id AS FLOAT) col2", "CAST(id AS LONG) col3"});
        rowDataset.write().mode(SaveMode.Append).parquet(location.toURI().toString());
        spark.read().schema(rowDataset.schema()).parquet(location.toURI().toString()).write().saveAsTable(tblName);
        List<Object[]> expectedBeforeAddColumn = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        List<Object[]> expectedAfterAddColumn = this.sql("SELECT col0, null, col1, col2, col3 FROM %s ORDER BY col0", tblName);
        SparkActions.get().migrateTable(tblName).execute();
        List<Object[]> afterMigarteBeforeAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedBeforeAddColumn, afterMigarteBeforeAddResults);
        SparkTable sparkTable = this.loadTable(tblName);
        sparkTable.table().updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).moveAfter("newCol", "col0").commit();
        List<Object[]> afterMigarteAfterAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedAfterAddColumn, afterMigarteAfterAddResults);
    }

    @Test
    public void schemaEvolutionTestWithSparkSQL() throws Exception {
        Assume.assumeTrue((String)"Cannot migrate to a hadoop based catalog", (!this.type.equals("hadoop") ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Can only migrate from Spark Session Catalog", (boolean)this.catalog.name().equals("spark_catalog"));
        String tblName = this.sourceName("schema_evolution_test_sql");
        spark.range(0L, 5L).selectExpr(new String[]{"CAST(id as INT) col0", "CAST(id AS FLOAT) col1", "CAST(id AS STRING) col2"}).write().mode(SaveMode.Append).saveAsTable(tblName);
        this.sql("ALTER TABLE %s ADD COLUMN col3 INT", tblName);
        spark.range(6L, 10L).selectExpr(new String[]{"CAST(id AS INT) col0", "CAST(id AS FLOAT) col1", "CAST(id AS STRING) col2", "CAST(id AS INT) col3"}).registerTempTable("tempdata");
        this.sql("INSERT INTO TABLE %s SELECT * FROM tempdata", tblName);
        List<Object[]> expectedBeforeAddColumn = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        List<Object[]> expectedAfterAddColumn = this.sql("SELECT col0, null, col1, col2, col3 FROM %s ORDER BY col0", tblName);
        SparkActions.get().migrateTable(tblName).execute();
        List<Object[]> afterMigarteBeforeAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedBeforeAddColumn, afterMigarteBeforeAddResults);
        SparkTable sparkTable = this.loadTable(tblName);
        sparkTable.table().updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).moveAfter("newCol", "col0").commit();
        List<Object[]> afterMigarteAfterAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedAfterAddColumn, afterMigarteAfterAddResults);
    }

    @Test
    public void testHiveStyleThreeLevelList() throws Exception {
        this.threeLevelList(true);
    }

    @Test
    public void testThreeLevelList() throws Exception {
        this.threeLevelList(false);
    }

    @Test
    public void testHiveStyleThreeLevelListWithNestedStruct() throws Exception {
        this.threeLevelListWithNestedStruct(true);
    }

    @Test
    public void testThreeLevelListWithNestedStruct() throws Exception {
        this.threeLevelListWithNestedStruct(false);
    }

    @Test
    public void testHiveStyleThreeLevelLists() throws Exception {
        this.threeLevelLists(true);
    }

    @Test
    public void testThreeLevelLists() throws Exception {
        this.threeLevelLists(false);
    }

    @Test
    public void testHiveStyleStructOfThreeLevelLists() throws Exception {
        this.structOfThreeLevelLists(true);
    }

    @Test
    public void testStructOfThreeLevelLists() throws Exception {
        this.structOfThreeLevelLists(false);
    }

    @Test
    public void testTwoLevelList() throws IOException {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", true);
        String tableName = this.sourceName("testTwoLevelList");
        File location = this.temp.newFolder();
        StructType sparkSchema = new StructType(new StructField[]{new StructField("col1", (DataType)new ArrayType((DataType)new StructType(new StructField[]{new StructField("col2", DataTypes.IntegerType, false, Metadata.empty())}), false), true, Metadata.empty())});
        String expectedParquetSchema = "message spark_schema {\n  optional group col1 (LIST) {\n    repeated group array {\n      required int32 col2;\n    }\n  }\n}\n";
        List<String> testData = Collections.singletonList("{\"col1\": [{\"col2\": 1}]}");
        spark.read().schema(sparkSchema).json(JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext()).parallelize(testData)).coalesce(1).write().format("parquet").mode(SaveMode.Append).save(location.getPath());
        File parquetFile = Arrays.stream((File[])Preconditions.checkNotNull((Object)location.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("parquet");
            }
        }))).findAny().get();
        ParquetFileReader pqReader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(parquetFile.getPath()), (Configuration)spark.sessionState().newHadoopConf()));
        MessageType schema = pqReader.getFooter().getFileMetaData().getSchema();
        Assert.assertEquals((Object)MessageTypeParser.parseMessageType((String)expectedParquetSchema), (Object)schema);
        this.sql("CREATE EXTERNAL TABLE %s (col1 ARRAY<STRUCT<col2 INT>>) STORED AS parquet LOCATION '%s'", tableName, location);
        List<Object[]> expected = this.sql("select array(struct(1))", new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected, results);
    }

    private void threeLevelList(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("threeLevelList_%s", useLegacyMode));
        File location = this.temp.newFolder();
        this.sql("CREATE TABLE %s (col1 ARRAY<STRUCT<col2 INT>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue = 12345;
        this.sql("INSERT INTO %s VALUES (ARRAY(STRUCT(%s)))", tableName, testValue);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected, results);
    }

    private void threeLevelListWithNestedStruct(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("threeLevelListWithNestedStruct_%s", useLegacyMode));
        File location = this.temp.newFolder();
        this.sql("CREATE TABLE %s (col1 ARRAY<STRUCT<col2 STRUCT<col3 INT>>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue = 12345;
        this.sql("INSERT INTO %s VALUES (ARRAY(STRUCT(STRUCT(%s))))", tableName, testValue);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected, results);
    }

    private void threeLevelLists(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("threeLevelLists_%s", useLegacyMode));
        File location = this.temp.newFolder();
        this.sql("CREATE TABLE %s (col1 ARRAY<STRUCT<col2 INT>>, col3 ARRAY<STRUCT<col4 INT>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue1 = 12345;
        int testValue2 = 987654;
        this.sql("INSERT INTO %s VALUES (ARRAY(STRUCT(%s)), ARRAY(STRUCT(%s)))", tableName, testValue1, testValue2);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected, results);
    }

    private void structOfThreeLevelLists(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("structOfThreeLevelLists_%s", useLegacyMode));
        File location = this.temp.newFolder();
        this.sql("CREATE TABLE %s (col1 STRUCT<col2 ARRAY<STRUCT<col3 INT>>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue1 = 12345;
        this.sql("INSERT INTO %s VALUES (STRUCT(STRUCT(ARRAY(STRUCT(%s)))))", tableName, testValue1);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.assertEquals("Output must match", expected, results);
    }

    private SparkTable loadTable(String name) throws NoSuchTableException, ParseException {
        return (SparkTable)this.catalog.loadTable(Spark3Util.catalogAndIdentifier((SparkSession)spark, (String)name).identifier());
    }

    private CatalogTable loadSessionTable(String name) throws NoSuchTableException, NoSuchDatabaseException, ParseException {
        Identifier identifier = Spark3Util.catalogAndIdentifier((SparkSession)spark, (String)name).identifier();
        Some namespace = Some.apply((Object)identifier.namespace()[0]);
        return spark.sessionState().catalog().getTableMetadata(new TableIdentifier(identifier.name(), (Option)namespace));
    }

    private void createSourceTable(String createStatement, String tableName) throws IOException, NoSuchTableException, NoSuchDatabaseException, ParseException {
        File location = this.temp.newFolder();
        spark.sql(String.format(createStatement, tableName, location));
        CatalogTable table = this.loadSessionTable(tableName);
        Seq partitionColumns = table.partitionColumnNames();
        String format = (String)table.provider().get();
        spark.table(this.baseTableName).write().mode(SaveMode.Append).format(format).partitionBy(partitionColumns.toSeq()).saveAsTable(tableName);
    }

    private void assertMigratedFileCount(MigrateTable migrateAction, String source, String dest) throws NoSuchTableException, NoSuchDatabaseException, ParseException {
        long expectedFiles = this.expectedFilesCount(source);
        MigrateTable.Result migratedFiles = (MigrateTable.Result)migrateAction.execute();
        this.validateTables(source, dest);
        Assert.assertEquals((String)"Expected number of migrated files", (long)expectedFiles, (long)migratedFiles.migratedDataFilesCount());
    }

    private void assertSnapshotFileCount(SnapshotTable snapshotTable, String source, String dest) throws NoSuchTableException, NoSuchDatabaseException, ParseException {
        long expectedFiles = this.expectedFilesCount(source);
        SnapshotTable.Result snapshotTableResult = (SnapshotTable.Result)snapshotTable.execute();
        this.validateTables(source, dest);
        Assert.assertEquals((String)"Expected number of imported snapshot files", (long)expectedFiles, (long)snapshotTableResult.importedDataFilesCount());
    }

    private void validateTables(String source, String dest) throws NoSuchTableException, ParseException {
        List expected = spark.table(source).collectAsList();
        SparkTable destTable = this.loadTable(dest);
        Assert.assertEquals((String)"Provider should be iceberg", (Object)"iceberg", destTable.properties().get("provider"));
        List actual = spark.table(dest).collectAsList();
        Assert.assertTrue((String)String.format("Rows in migrated table did not match\nExpected :%s rows \nFound    :%s", expected, actual), (expected.containsAll(actual) && actual.containsAll(expected) ? 1 : 0) != 0);
    }

    private long expectedFilesCount(String source) throws NoSuchDatabaseException, NoSuchTableException, ParseException {
        List<Object> uris;
        CatalogTable sourceTable = this.loadSessionTable(source);
        if (sourceTable.partitionColumnNames().size() == 0) {
            uris = Lists.newArrayList();
            uris.add(sourceTable.location());
        } else {
            Seq catalogTablePartitionSeq = spark.sessionState().catalog().listPartitions(sourceTable.identifier(), Option.apply(null));
            uris = JavaConverters.seqAsJavaList((Seq)catalogTablePartitionSeq).stream().map(CatalogTablePartition::location).collect(Collectors.toList());
        }
        return uris.stream().flatMap(uri -> FileUtils.listFiles((File)Paths.get(uri).toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream()).filter(file -> !file.toString().endsWith("crc") && !file.toString().contains("_SUCCESS")).count();
    }

    private void assertIsolatedSnapshot(String source, String dest) {
        List expected = spark.sql(String.format("SELECT * FROM %s", source)).collectAsList();
        ArrayList extraData = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(4, "d")});
        Dataset df = spark.createDataFrame((List)extraData, SimpleRecord.class);
        df.write().format("iceberg").mode("append").saveAsTable(dest);
        List result = spark.sql(String.format("SELECT * FROM %s", source)).collectAsList();
        Assert.assertEquals((String)"No additional rows should be added to the original table", (long)expected.size(), (long)result.size());
        List snapshot = spark.sql(String.format("SELECT * FROM %s WHERE id = 4 AND data = 'd'", dest)).collectAsList();
        Assert.assertEquals((String)"Added row not found in snapshot", (long)1L, (long)snapshot.size());
    }

    private String sourceName(String source) {
        return "default." + this.catalog.name() + "_" + this.type + "_" + source;
    }

    private String destName(String dest) {
        if (this.catalog.name().equals("spark_catalog")) {
            return "default." + this.catalog.name() + "_" + this.type + "_" + dest;
        }
        return this.catalog.name() + "." + NAMESPACE + "." + this.catalog.name() + "_" + this.type + "_" + dest;
    }
}

